import { NextRequest, NextResponse } from "next/server";
import { verifyToken } from "@/lib/jwt";

export function middleware(req: NextRequest) {
  const accessToken = req.cookies.get("access_token");

  // Public routes (no auth required)
  const publicRoutes = ["/login", "/register", "/api/auth/login", "/api/auth/register"];

  console.log(!publicRoutes.some(route => req.nextUrl.pathname.startsWith(route)))

  if (!publicRoutes.some(route => req.nextUrl.pathname.startsWith(route))) {
    // return NextResponse.next();
    return NextResponse.redirect(new URL("/login", req.url));
  }

  // No token → redirect to login
  if (!accessToken) {
    return NextResponse.redirect(new URL("/login", req.url));
  }

  // Verify token
  // const payload = verifyToken(accessToken);

  // if (!payload) {
    // return NextResponse.redirect(new URL("/login", req.url));
  }

  // return NextResponse.next();
// }


export const config = {
  matcher: [
    "/dashboard/:path*",
    "/api/protected/:path*",
  ],
};