"use client"
import { Camera, ShieldCheck, Loader2, AlertCircle, ChevronRight } from "lucide-react";
import { SETTINGS_MAP } from "@/lib/search-data";
import GlobalSearch from "@/components/Search/GlobalSearch";
import { useAuth } from "@/context/AuthContext"
import Link from "next/link";
import { clsx, type ClassValue } from "clsx";
import { twMerge } from "tailwind-merge";

// Utility for cleaner class management
function cn(...inputs: ClassValue[]) {
  return twMerge(clsx(inputs));
}

const API_URL = process.env.NEXT_PUBLIC_API_BASE_URL

export default function DashboardPage() {
  const quickLinks = ["My password", "Devices", "Password Manager", "My Activity", "Email"];
  const { user, loading } = useAuth();

  // Alert Configuration
  // const missingInfoAlerts = [
  //   {
  //     id: 'recovery_email',
  //     show: user?.recovery_email,
  //     title: "Recovery email is missing",
  //     description: "Update your recovery email to ensure you can always access your account if you lose your password.",
  //     icon: <AlertCircle className="h-5 w-5" />,
  //     colorClass: "bg-blue-50/50 border-blue-100",
  //     path: "/settings/security"
  //   }
  // ].filter(a => a.show);



  // Alert Configuration
  const missingInfoAlerts = [
    {
      id: 'last_name',
      show: !user?.last_name,
      title: "Add your last name",
      description: "Help us know you better by completing your profile name.",
      icon: <AlertCircle className="h-5 w-5" />,
      colorClass: "bg-blue-500/5 border-blue-500/30 text-blue-600",
      path: "/settings"
    },
    {
      id: 'verify_email',
      show: !user?.primary_email_verified,
      title: "Verify your email",
      description: "Please verify your primary email to secure your account and access all features.",
      icon: <AlertCircle className="h-5 w-5" />,
      colorClass: "bg-red-500/5 border-red-500/30 text-red-600",
      path: "/settings"
    },
    {
      id: 'gender',
      show: !user?.gender,
      title: "Gender information missing",
      description: "This helps us personalize your experience across services.",
      icon: <AlertCircle className="h-5 w-5" />,
      colorClass: "bg-blue-500/5 border-blue-500/30 text-blue-600",
      path: "/settings"
    },
    {
      id: 'dob',
      show: !user?.dob,
      title: "Add date of birth",
      description: "Ensure you're getting the right experience for your age group.",
      icon: <AlertCircle className="h-5 w-5" />,
      colorClass: "bg-blue-500/5 border-blue-500/30 text-blue-600",
      path: "/settings"
    },
    {
      id: 'recovery_email',
      show: !user?.recovery_email || !user?.recovery_email_verified,
      title: "Recovery email",
      description: "Add or verify a recovery email to avoid getting locked out of your account.",
      icon: <AlertCircle className="h-5 w-5" />,
      colorClass: "bg-amber-500/5 border-amber-500/30 text-amber-600",
      path: "/settings"
    },
    {
      id: 'recovery_phone',
      show: !user?.recovery_phone || !user?.recovery_phone_verified,
      title: "Recovery phone",
      description: "A verified phone number helps you recover your account safely via SMS.",
      icon: <AlertCircle className="h-5 w-5" />,
      colorClass: "bg-amber-500/5 border-amber-500/30 text-amber-600",
      path: "/settings"
    },

    {
      id: 'profile_picture',
      show: !user?.profile_picture,
      title: "Add a profile picture",
      description: "A personalized photo helps people recognize you and lets you know you're signed in to your account.",
      icon: <Camera className="h-5 w-5" />,
      colorClass: "bg-blue-500/5 border-blue-500/30 text-blue-600",
      path: "/settings"
    },
    {
      id: 'address',
      show: !user?.address,
      title: "Add your home address",
      description: "Your address is used to provide relevant results in Search and better routes in Maps.",
      icon: <AlertCircle className="h-5 w-5" />,
      colorClass: "bg-blue-500/5 border-blue-500/30 text-blue-600",
      path: "/settings"
    }

  ].filter(a => a.show);


  if (loading) {
    return (
      <div className="h-screen w-full flex items-center justify-center bg-background">
        <div className="flex flex-col items-center gap-4">
          <Loader2 className="h-8 w-8 animate-spin text-sidebar-primary" />
          <p className="text-muted-foreground animate-pulse">Loading your account...</p>
        </div>
      </div>
    );
  }

  return user ? (
    <div className="max-w-4xl mx-auto pt-12 px-6 h-full flex flex-col">
      {/* Profile Section */}
      <div className="flex flex-col items-center text-center mb-10">
        <div className="relative group cursor-pointer">
          <div className="w-24 h-24 rounded-full bg-sidebar-primary flex items-center justify-center text-3xl text-white font-semibold overflow-hidden shadow-sm">
            {!user.profile_picture ? (
              user.first_name?.charAt(0).toUpperCase()
            ) : (
                <img src={`${user.profile_picture}`} alt="Profile" className="w-full h-full object-cover" />
              )}
          </div>
          <Link href="/settings" className="absolute bottom-0 right-0 bg-background border border-border p-1.5 rounded-full shadow-sm">
            <Camera size={16} className="text-muted-foreground" />
          </Link>
        </div>
        <h1 className="mt-4 text-3xl font-normal text-foreground">{user?.first_name}</h1>
        <p className="text-muted-foreground text-sm">{user?.primary_email}</p>
      </div>

      {/* Search Bar */}
      <div className="relative mb-8">
        <GlobalSearch data={SETTINGS_MAP} placeholder="Search settings..." />
      </div>

      {/* Chips */}
      <div className="flex flex-wrap justify-center gap-2 mb-12">
        {quickLinks.map((link) => (
          <button
            key={link}
            className="px-4 py-2 border border-border rounded-lg text-sm font-medium hover:bg-accent transition-colors"
          >
            {link}
          </button>
        ))}
      </div>

      {/* Alert Section */}
      {missingInfoAlerts.length > 0 && (
        <div className="mb-8 space-y-4">
          {missingInfoAlerts.map((alert) => (
            <Link
              key={alert.id}
              href={alert.path}
              className={cn(
                "p-5 rounded-2xl border flex items-center justify-between gap-4 transition-all hover:shadow-sm animate-in fade-in zoom-in-95 duration-300 group",
                alert.colorClass
              )}
            >
              <div className="flex items-start gap-4">
                <div className="bg-amber-500/5">{alert.icon}</div>
                <div className="space-y-1">
                  <h4 className="font-bold text-sm leading-none">{alert.title}</h4>
                  <p className="text-xs leading-relaxed">
                    {alert.description}
                  </p>
                </div>
              </div>

              <ChevronRight size={18} className="group-hover:translate-x-1 transition-transform shrink-0" />
            </Link>
          ))}
        </div>
      )}



      {/* Info Footer */}
      <div className="flex flex-col-reverse items-center gap-3 mt-auto p-4 rounded-xl border border-transparent hover:bg-accent/50 transition-all md:flex-row md:items-start md:space-x-4 md:gap-0">
        <p className="text-xs text-muted-foreground leading-relaxed text-center md:text-left">
          Only you can see your settings. You might also want to review your settings for Maps,
          Search or whatever service that you use the most. Google keeps your data private,
          safe and secure. <a href="#" className="text-blue-500 hover:underline">Learn more</a>
        </p>
        <div className="text-blue-600 shrink-0">
          <ShieldCheck size={24} />
        </div>
      </div>
    </div>
  ) : null;
}