"use client";
import { useState, useEffect } from "react";
import {
  Monitor, Smartphone, Tablet, Globe, Shield,
  LogOut, Loader2, CheckCircle2, AlertCircle, Clock, MapPin, RefreshCcw, 
} from "lucide-react";
import { cn } from "@/lib/utils";
import { useRouter } from "next/navigation"
import { Toast } from '@/components/ui/Toast';
import { authService } from "@/lib/auth"
interface Device {
  session_id: string;
  device_id: string;
  ip_address: string;
  browser: string;
  os: string;
  created_at: string;
  last_active: string;
  is_active: boolean;
  country_name : string;
  city : string;
  region : string;
}

export default function SecurityDevicesPage() {
  const [devices, setDevices] = useState<Device[]>([]);
  const [loading, setLoading] = useState(true);
  const [terminatingId, setTerminatingId] = useState<string | null>(null);
  // const [toast, setToast] = useState({ show: false, msg: "" });
  const [isInitialLoading, setIsInitialLoading] = useState(true);
  const [toast, setToast] = useState<{ type: 'success' | 'error', message: string } | null>(null);
  const router = useRouter()
  // const fetchDevices = async () => {
  //   try {
  //     setLoading(true)
  //     const response = await fetch(`${process.env.NEXT_PUBLIC_API_BASE_URL}/api/auth/logged-in-devices/`, {
  //       method: "POST",
  //       headers: { "Content-Type": "application/json" },
  //       credentials: "include",
  //     });
  //     const data = await response.json();
  //     setDevices(data.devices || []);
  //   } catch (error) {
  //     console.error("Failed to fetch devices", error);
  //   } finally {
  //     setLoading(false);
  //   }
  // };

  const fetchDevices = async () => {
    try {
      setLoading(true);
      const result = await authService.getLoggedInDevices();
      if (result.success) {
        setDevices(result.data?.devices || []);
      }
    } catch (error) {
      setToast({ type: 'error', message: "Failed to fetch devices" });
      console.error("Failed to fetch devices", error);
    } finally {
      setLoading(false);
    }
  };

  useEffect(() => { fetchDevices(); }, []);

  // const handleLogoutDevice = async (deviceId: string, sessionId: string) => {
  //   setTerminatingId(sessionId);
  //   try {
  //     const response = await fetch(`${process.env.NEXT_PUBLIC_API_BASE_URL}/api/auth/logout-device/`, {
  //       method: "POST",
  //       headers: { "Content-Type": "application/json" },
  //       credentials: "include",
  //       body: JSON.stringify({ session_id: sessionId, device_id: deviceId }),
  //     });

  //     if (response.ok) {
  //       setDevices(devices.filter(d => d.session_id !== sessionId));
  //       setToast({ type: 'success', message: "Device signed out successfully" });
  //       // setToast({ show: true, msg: "Device signed out successfully" });
  //       // setTimeout(() => setToast({ show: false, msg: "" }), 4000);
  //     }
  //   } catch (error) {
  //     console.error("Logout failed", error);
  //   } finally {
  //     setTerminatingId(null);
  //   }
  // };


  const handleLogoutDevice = async (deviceId: string, sessionId: string) => {
    setTerminatingId(sessionId);
    if (thisDeviceId == deviceId) {
      try {
        const res = await authService.logoutAccount()
        if (res.success)
          window.location.reload();
        return

      } catch (e) {

      } finally {
        setTerminatingId(null);
      }
    }
    try {
      const result = await authService.logoutDevice(deviceId, sessionId);

      if (result.success) {
        setDevices(prev => prev.filter(d => d.session_id !== sessionId));
        setToast({ type: 'success', message: "Device signed out successfully" });
        // setShowToast(true);

      } else {
        setToast({ type: 'error', message: result.message || "Failed to logout device" });
        // setShowToast(true);
      }
    } catch (error) {
      console.error("Logout failed", error);
    } finally {
      setTerminatingId(null);
    }
  };


  const [logoutAllLoading, setLogoutAllLoading] = useState(false)
  // const handleLogoutAllDevice = async () => {
  //   setLogoutAllLoading(true)
  //   try {
  //     const response = await fetch(`${process.env.NEXT_PUBLIC_API_BASE_URL}/api/auth/logout-all/`, {
  //       method: "POST",
  //       headers: { "Content-Type": "application/json" },
  //       credentials: "include",
  //     });

  //     if (response.ok) {
  //       // setToast({ show: true, msg: "All Device signed out successfully" });
  //       setToast({ type: "success", message: "All Device signed out successfully" })
  //       // setTimeout(() => setToast({ show: false, msg: "" }), 4000);
  //       router.push("/login")
  //     }
  //   } catch (error) {
  //     console.error("Logout failed", error);
  //   } finally {
  //     setLogoutAllLoading(false)
  //   }
  // };


  const handleLogoutAllDevice = async () => {
    setLogoutAllLoading(true);
    try {
      const result = await authService.logoutAllDevices();

      if (result.success) {
        setToast({ type: "success", message: "All devices signed out successfully" });
        // setShowToast(true);
        router.push("/login");
      } else {
        setToast({ type: 'error', message: result.message || "Failed to logout all devices" });
        // setShowToast(true);
      }
    } catch (error) {
      setToast({ type: "error", message: "Logout failed" })
      console.error("Logout failed", error);
    } finally {
      setLogoutAllLoading(false);
    }
  };

  const [thisDeviceId, setThisDeviceId] = useState<string | null>(null);
  useEffect(() => {
    const deviceId = localStorage.getItem("device_id")
    setThisDeviceId(deviceId)

  }, [])
  // const handleLogoutDevice = async (deviceId: string) => {
  //     setTerminatingId(deviceId);
  //     try {
  //       // Switched to use device_id as requested
  //       const response = await fetch(`${process.env.NEXT_PUBLIC_API_BASE_URL}/api/auth/logout-device/`, {
  //         method: "POST",
  //         headers: { "Content-Type": "application/json" },
  //         credentials: "include",
  //         body: JSON.stringify({ device_id: deviceId }),
  //       });

  //       if (response.ok) {
  //         setDevices(devices.filter(d => d.device_id !== deviceId));
  //         setToast({ show: true, msg: "Device signed out" });
  //         setTimeout(() => setToast({ show: false, msg: "" }), 4000);
  //       }
  //     } finally {
  //       setTerminatingId(null);
  //     }
  //   };

  //  /**
  //  * Converts a UTC ISO string to the user's local system time.
  //  * @param {string} utcString - The date string (e.g., "2026-01-28T10:16:47.438000")
  //  * @returns {string} - Formatted local date and time
  //  */
  function formatToLocalTime(utcString) {
    if (!utcString) return "N/A";

    // 1. Ensure the string ends with 'Z' so JS treats it as UTC
    const normalizedDate = utcString.endsWith('Z') ? utcString : utcString + 'Z';

    // 2. Create the date object
    const date = new Date(normalizedDate);

    // 3. Check for invalid dates
    if (isNaN(date.getTime())) return "Invalid Date";

    // 4. Return formatted based on user's system locale
    return date.toLocaleString(undefined, {
      dateStyle: 'medium', // e.g., Jan 28, 2026
      timeStyle: 'short',  // e.g., 3:46 PM
      hour12: true         // Uses AM/PM
    });
  }

  const getDeviceIcon = (os: string) => {
    const name = os.toLowerCase();
    if (name.includes("windows") || name.includes("mac") || name.includes("linux")) return <Monitor size={22} />;
    if (name.includes("android") || name.includes("iphone")) return <Smartphone size={22} />;
    return <Globe size={22} />;
  };

  if (loading) return <div className="h-screen flex items-center justify-center"><Loader2 className="animate-spin text-sidebar-primary" /></div>;

  return (
    <div className="max-w-3xl mx-auto pt-8 pb-20 px-4 animate-in fade-in duration-500">
      <div className="mb-8 flex justify-between items-start">
        <div>
          <h1 className="text-3xl font-bold tracking-tight">Your devices</h1>
          <p className="text-muted-foreground mt-1">You're currently signed in to your account on these devices.
          If you see something unfamiliar, sign out to secure your account.</p>
        </div>
        <button
          onClick={() => { setLoading(true); fetchDevices(); }}
          className="p-2 hover:bg-accent rounded-lg transition-colors border border-border"
        >
          <RefreshCcw size={18} className={cn(loading && "animate-spin")} />
        </button>
      </div>

      <div className="bg-card border rounded-2xl overflow-hidden shadow-sm">
        {/* Header Summary */}
        <div className="flex justify-between">
          <div className="w-full p-6 border-b bg-sidebar-primary/5 flex items-center gap-4">
            <div className="w-full flex flex-col md:flex-row gap-2 justify-between">
              <div className="flex items-center gap-4">
                <div className="p-3 bg-sidebar-primary/10 rounded-xl text-sidebar-primary">
                  <Shield size={24} />
                </div>
                <div>
                  <h3 className="font-bold text-sm">Account Security</h3>
                  <p className="text-xs text-muted-foreground">Total {devices.length} active sessions</p>
                </div>
              </div>


              <button
                disabled={logoutAllLoading}
                onClick={() => handleLogoutAllDevice()}
                className={cn(
                  "min-w-[130px] px-6 h-10 rounded-lg font-bold text-xs uppercase tracking-wider transition-all flex items-center justify-center gap-2",
                  false
                    ? "bg-secondary text-secondary-foreground hover:bg-destructive hover:text-white"
                    : "bg-primary text-primary-foreground hover:shadow-lg hover:-translate-y-0.5"
                )}
              >
                {logoutAllLoading ? (
                  <Loader2 className="animate-spin" size={18} />
                ) : (
                    <LogOut size={18} />
                  )} Sign Out All
              </button>

              {/* <button
                onClick={() => handleLogoutAllDevice()}
                className={cn(
                  "flex items-center gap-4 p-2.5 px-4 rounded-xl border border-border hover:bg-red-600/5 hover:border-red-600/20 hover:text-red-600 transition-all group bg-primary text-primary-foreground font-bold text-sm",
                )}
                title="Sign out from All device"
              >
                Sign Out All
                {logoutAllLoading ? (
                  <Loader2 className="animate-spin" size={18} />
                ) : (
                    <LogOut size={18} />
                  )}


              </button> */}
            </div>
          </div>

        </div>

        {/* Device List */}
        <div className="divide-y divide-border">
          {devices.map((device) => (
            <div key={device.session_id} className="p-6 flex items-start justify-between hover:bg-accent/20 transition-colors">
              <div className="flex gap-5">
                <div className="mt-1 p-3 bg-muted rounded-xl text-muted-foreground">
                  {getDeviceIcon(device.os)}
                </div>
                <div className="space-y-1">
                  <div className="flex flex-col md:flex-row gap-2">
                    <h4 className="font-bold text-base">
                      {device.os === "Other" ? "Unknown Device" : device.os} • {device.browser}
                    </h4>
                    <div className="flex gap-2">
                      {device.is_active && (
                        <span className="flex items-center text-center gap-1 text-[10px] font-bold uppercase tracking-wider bg-green-500/10 text-green-600 px-2 py-0.5 rounded-full">
                          Active Session
                        </span>
                      )}
                      {device.device_id == thisDeviceId && (
                        <span className="flex items-center text-center gap-1 text-[10px] font-bold uppercase tracking-wider bg-amber-500/10 text-amber-600 px-2 py-0.5 rounded-full">
                          Current Device
                        </span>
                      )}
                    </div>
                  </div>

                  <div className="flex flex-col gap-1.5 pt-1">
                    <div className="flex items-center gap-2 text-xs text-muted-foreground">
                      <Globe size={12} />
                      <span>IP: {device.ip_address}</span>
                    </div>
                     <div className="flex items-center gap-2 text-xs text-muted-foreground">
                      <MapPin size={12} />
                      <span>Location: {device.city || ""} | {device.country_name || ""} | {device.region || ""}</span>
                    </div>
                    <div className="flex items-center gap-2 text-xs text-muted-foreground">
                      <Clock size={12} />
                      <span>Last active : {formatToLocalTime(device.last_active)}</span>
                      {/* <span>Last active: {new Date(device.last_active).toLocaleString()}</span> */}
                    </div>
                  </div>
                </div>
              </div>

              <button
                onClick={() => handleLogoutDevice(device.device_id, device.session_id)}
                disabled={terminatingId === device.session_id}
                className={cn(
                  "p-2.5 rounded-xl border border-border hover:bg-destructive/5 hover:border-destructive/20 hover:text-red-600 transition-all group",
                  terminatingId === device.session_id && "opacity-50"
                )}
                title="Sign out from this device"
              >
                {terminatingId === device.session_id ? (
                  <Loader2 className="animate-spin" size={18} />
                ) : (
                    <LogOut size={18} />
                  )}
              </button>
            </div>
          ))}
        </div>
      </div>

      {/* Safety Info */}
      <div className="mt-8 p-6 border rounded-2xl bg-amber-500/5 border-amber-500/20 flex gap-4">
        <AlertCircle className="text-amber-600 shrink-0" size={24} />
        <div>
          <h4 className="text-sm font-bold text-amber-700">Don't recognize a device?</h4>
          <p className="text-xs text-amber-600/80 leading-relaxed mt-1">
            If you see a device or location you don't recognize, sign out immediately
            and change your password to keep your account safe.
          </p>
        </div>
      </div>

      {/* Toast Notification */}
      {/* {toast.show && (
        <div className="fixed bottom-8 left-8 z-50 bg-[#323232] text-white px-6 py-3 rounded-lg shadow-2xl flex items-center gap-3 animate-in slide-in-from-left-10">
          <CheckCircle2 size={18} className="text-green-400" />
          <span className="text-sm font-medium">{toast.msg}</span>
        </div>
      )} */}

      {toast && (
        <Toast
          message={toast.message}
          type={toast.type}
          onClose={() => setToast(null)}
        />
      )}
    </div>
  );
}