"use client";
import { useState, useEffect } from "react";
import { Navbar } from "@/components/layout/Navbar";
import { Sidebar } from "@/components/layout/Sidebar";
import { cn } from "@/lib/utils";
import { useAuth } from "@/context/AuthContext"
import { useRouter } from "next/navigation";
import { Loader2 } from "lucide-react";

export default function DashboardLayout({ children }: { children: React.ReactNode }) {
  const [isMobileMenuOpen, setIsMobileMenuOpen] = useState(false);
  const { user, loading, refreshUser } = useAuth()



  // const fetchUserInfo = async () => {
  //   const res = await fetch(`${process.env.NEXT_PUBLIC_API_BASE_URL}/api/auth/me/`, {
  //     method: "GET",
  //     credentials: "include", // Essential for cookie-based auth
  //   });

  //   if (res.ok) {
  //     const userData = await res.json();
  //     console.log(userData)
  //     // const data = await res.json()
  //     // setUser(data.user)
  //   }
  //   // throw new Error("Session invalid");

  // };

  // useEffect(() => {
  //   fetchUserInfo()
  // }, [])

  const router = useRouter();

  useEffect(() => {
    // If loading is finished and there is no user, redirect to login
    if (!loading && !user) {
      router.push("/login");
    }
  }, [user, loading, router]);

  // Optional: Re-fetch user data whenever the dashboard layout mounts 
  // to ensure data is fresh.
  useEffect(() => {
    if (user) refreshUser();
  }, []);

  if (loading) {
    return (
      <div className="h-screen w-full flex items-center justify-center bg-background">
        <div className="flex flex-col items-center gap-4">
          <Loader2 className="h-8 w-8 animate-spin text-sidebar-primary" />
          <p className="text-muted-foreground animate-pulse">Loading your account...</p>
        </div>
      </div>
    );
  }


  return user ? (
    <div className="min-h-screen bg-background">
      <Navbar onMenuClick={() => setIsMobileMenuOpen(true)} />

      <div className="flex">
        <Sidebar
          isOpen={isMobileMenuOpen}
          onClose={() => setIsMobileMenuOpen(false)}
          isAdmin={user.is_admin}
        />

        {/* Main Content Area */}
        <main className={cn(
          "flex-1 transition-all duration-300 mt-16 p-4 ",

          "min-h-[calc(100vh-64px)]"
        )}>
          {children}
        </main>
      </div>
    </div>
  ): null;
}