"use client";
import { useState, useEffect, useRef } from "react";
import {
  Camera, User, Mail, Phone, Cake, Languages, ChevronRight,
  ArrowLeft, CheckCircle2, Loader2, Lock, AlertCircle, Calendar,
} from "lucide-react";
import { cn } from "@/lib/utils";
import CustomCalendar from '@/components/CustomCalendar';
import { useAuth } from "@/context/AuthContext"
import InfoRow from "@/components/dashboard/InfoRow"
// --- Components ---



export default function PersonalInfoPage() {
  const [editingField, setEditingField] = useState<string | null>(null);
  const [isSaving, setIsSaving] = useState(false);
  const [showToast, setShowToast] = useState(false);
  const [toastMsg, setToastMsg] = useState("");
  const [isResending, setIsResending] = useState(false);
  const [resendCooldown, setResendCooldown] = useState(0);

  const [isVerifying, setIsVerifying] = useState(false);
  const [otp, setOtp] = useState("");
  const [isDirty, setIsDirty] = useState(false);



  const [verifyingField, setVerifyingField] = useState<string | null>(null);
  const [otpMap, setOtpMap] = useState<Record<string, string>>({});
  const [cooldownMap, setCooldownMap] = useState<Record<string, number>>({});


  // User Data State
  const { user, loading, refreshUser } = useAuth()
  const [profile, setProfile] = useState({
    firstName: user?.first_name,
    lastName: user?.last_name,
    gender: user?.gender,
    primaryPhone: user?.phone_number,
    primaryPhoneVerified: true,
    recoveryPhone: user?.recovery_phone,
    recoveryPhoneVerified: user?.recovery_phone_verified,
    primaryEmail: user?.primary_email,
    primaryEmailVerified: user?.primary_email_verified, // User needs to verify
    recoveryEmail: user?.recovery_email,
    recoveryEmailVerified: user?.recovery_email_verified,
    birthday: user?.dob
  });

  // console.log(user)

  const [selectedDate, setSelectedDate] = useState(profile.birthday);
  const [isOpen, setIsOpen] = useState(false);
  const containerRef = useRef(null);


  const handleDateSelect = (date) => {
    // setSelectedDate(date);
    setIsOpen(false); // Close after selection
  };

  // Close the calendar if the user clicks outside
  useEffect(() => {
    const handleClickOutside = (event) => {
      if (containerRef.current && !containerRef.current.contains(event.target)) {
        setIsOpen(false);
      }
    };
    document.addEventListener('mousedown', handleClickOutside);
    return () => document.removeEventListener('mousedown', handleClickOutside);
  }, []);

  const [editBuffer, setEditBuffer] = useState<any>(null);

  const startEdit = (field: string) => {
    setEditingField(field);
    setEditBuffer({ ...profile });


    setVerifyingField(null);
  };

  // Update the "Back" or "Cancel" handler to reset these
  const closeEdit = () => {
    setEditingField(null);
    setIsVerifying(false);
    setIsDirty(false);
    setOtp("");
    setToastMsg("");
    setShowToast(false);

    setVerifyingField(null);
    setOtpMap({});
  };


  const triggerVerification = (type: string) => {
    setIsSaving(true);
    // Simulate sending OTP/Email
    setTimeout(() => {
      setIsSaving(false);
      setToastMsg(`Verification link sent to your ${type}`);
      setShowToast(true);
    }, 1000);
  };

  useEffect(() => {
    if (showToast) {
      const timer = setTimeout(() => setShowToast(false), 4000);
      return () => clearTimeout(timer);
    }
  }, [showToast]);


  useEffect(() => {
    let interval;
    if (resendCooldown > 0) {
      interval = setInterval(() => {
        setResendCooldown((current) => current - 1);
      }, 1000);
    }
    return () => clearInterval(interval);
  }, [resendCooldown]);


  const prevValueRef = useRef("");


  const updateValue = async () => {

    try {
      const response = await fetch(`${process.env.NEXT_PUBLIC_API_BASE_URL}/api/accounts/update-profile/`, {
        method: "PATCH",
        headers: { "Content-Type": "application/json" },
        credentials: "include",
        body: JSON.stringify({
          first_name: editBuffer.firstName,
          last_name: editBuffer.lastName,
          dob: editBuffer.birthday,
          gender: editBuffer.gender,
          // recovery_phone: editBuffer.recoveryPhone,
          // primary_email: editBuffer.primaryEmail,
          // recovery_email: editBuffer.recoveryEmail,

        }),
      });

      if (response.ok) {
        // await refreshUser(); // Sync with AuthContext
        // setProfile(editBuffer);
        // setEditingField(null);
        setToastMsg("Changes saved successfully");
        setShowToast(true);
      } else {
        setToastMsg("Failed to update profile");
        setShowToast(true);
      }
    } catch (error) {
      console.error("Save error:", error);
    } finally {
      setIsSaving(false);
    }

  }
  const handleVerify = async () => {
    console.log(prevValueRef.current)
    console.log(editBuffer[editingField])
    if ((prevValueRef.current == editBuffer[editingField])) {
      setIsVerifying(true)
      return
    }
    prevValueRef.current = editBuffer[editingField] || ""
    setIsVerifying(true)
    // setResendCooldown(0)
    // setIsResending(false)
    // await updateValue()
    setSendOTPFor(editingField)
    handleResendClick()
  }

  const handleChange = () => {
    setIsVerifying(false);
  };

  // const handleSave = async () => {
  //   setIsSaving(true);
  //   await new Promise(r => setTimeout(r, 800));
  //   setProfile(editBuffer);
  //   setIsSaving(false);
  //   setEditingField(null);
  //   setToastMsg("Changes saved");
  //   setShowToast(true);
  // };



  const [sendOTPFor, setSendOTPFor] = useState("")

  const handleSave = async () => {
    setIsSaving(true);
    try {
      const response = await fetch(`${process.env.NEXT_PUBLIC_API_BASE_URL}/api/accounts/update-profile/`, {
        method: "PATCH",
        headers: { "Content-Type": "application/json" },
        credentials: "include",
        body: JSON.stringify({
          first_name: editBuffer.firstName,
          last_name: editBuffer.lastName,
          dob: editBuffer.birthday,
          gender: editBuffer.gender,
          // recovery_phone: editBuffer.recoveryPhone,
          // primary_email: editBuffer.primaryEmail,
          // recovery_email: editBuffer.recoveryEmail,

        }),
      });

      if (response.ok) {
        await refreshUser(); // Sync with AuthContext
        setProfile(editBuffer);
        setEditingField(null);
        setToastMsg("Changes saved successfully");
        setShowToast(true);
      } else {
        setToastMsg("Failed to update profile");
        setShowToast(true);
      }
    } catch (error) {
      console.error("Save error:", error);
    } finally {
      setIsSaving(false);
    }
  };



  const PURPOSE = {
    primaryEmail: "primary_email",
    recoveryPhone: "recovery_phone",
    recoveryEmail: "recovery_email"

  }


  const handleResendClick = async () => {
    setIsResending(true);

    try {
      const response = await fetch(`${process.env.NEXT_PUBLIC_API_BASE_URL}/api/auth/otp/recovery/identifier/send/`, {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        credentials: "include",
        body: JSON.stringify({
          //type: editingField, // e.g., 'primaryEmail' or 'recoveryPhone'
          identifier: editBuffer[editingField],
          purpose: PURPOSE[editingField]
        }),
      });


      const data = await response.json()
      if (response.ok) {
        setResendCooldown(30);
        setToastMsg("Verification code sent");
        setShowToast(true);
      } else {
        setIsVerifying(false);
        setToastMsg(data.error);
        setShowToast(true);
      }
    } catch (error) {
      setIsVerifying(false);
      setToastMsg("Something went wrong");
      setShowToast(true);
    } finally {
      setIsResending(false);
    }
  };


  // Add this inside your component
  useEffect(() => {
    if (otp.length === 6) {
      verifyOtp();
    }
  }, [otp]);

  const verifyOtp = async () => {
    setIsSaving(true);
    try {
      const response = await fetch(`${process.env.NEXT_PUBLIC_API_BASE_URL}/api/auth/recovery/otp/verify/`, {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        credentials: "include",
        body: JSON.stringify({
          identifier: editBuffer[editingField],
          otp: otp,
          purpose: PURPOSE[editingField],
        }),
      });

      if (response.ok) {
        await refreshUser(); // Update global auth state
        setEditingField(null);
        setIsVerifying(false);
        setToastMsg("Identity verified and updated");
        setShowToast(true);
        
      } else {
        setToastMsg("Invalid code, please try again");
        setShowToast(true);
        setOtp(""); // Reset input on failure
      }
    } catch (error) {
      setToastMsg("Verification failed");
    } finally {
      setIsSaving(false);
       setOtp(""); 
    }
  };


  useEffect(() => {
    if (user) {
      setProfile({
        firstName: user.first_name,
        lastName: user.last_name,
        gender: user.gender,
        primaryPhone: user.phone_number,
        primaryPhoneVerified: true,
        recoveryPhone: user.recovery_phone,
        recoveryPhoneVerified: user.recovery_phone_verified,
        primaryEmail: user.primary_email,
        primaryEmailVerified: user.primary_email_verified,
        recoveryEmail: user.recovery_email,
        recoveryEmailVerified: user.recovery_email_verified,
        birthday: user.dob
      });
      setIsDirty(false)



    }
  }, [user]);



  
  if (editingField) {
    return (
      <div className="max-w-3xl mx-auto pt-8 pb-20 px-4 animate-in fade-in slide-in-from-bottom-4" ref={containerRef}>
        <button onClick={() => setEditingField(null)} className="flex items-center gap-2 text-muted-foreground mb-8">
          <ArrowLeft size={20} /> <span className="text-sm font-medium">Back</span>
        </button>

        <div className="space-y-6">
          <h1 className="text-3xl font-normal capitalize">
            {editingField === "primaryEmail" ? "Email address" : editingField.replace(/([A-Z])/g, ' $1')}
          </h1>

          <div className="bg-card border border-border rounded-2xl p-6 space-y-6 shadow-sm">

            {/* BIRTHDAY (CALENDAR VIEW) */}
            {editingField === "birthday" && (
              <div className="relative"
                onClick={() => setIsOpen(!isOpen)}
              >

                <input
                  type="text"
                  className="w-full bg-transparent border-2 border-muted focus:border-sidebar-primary rounded-xl px-4 py-4 outline-none appearance-none"
                  value={editBuffer.birthday}
                  onChange={(e) => setEditBuffer({ ...editBuffer, birthday: e.target.value })}
                />
                <Calendar className="absolute right-4 top-4 text-muted-foreground pointer-events-none" size={20} />

                <label className="absolute left-3 -top-2.5 px-2 bg-card text-xs text-sidebar-primary">Select Birthday</label>
              </div>
            )}

            {isOpen && (
              <div className="fixed w-full h-full top-0 left-0 z-50 flex justify-center align-middle animate-in fade-in zoom-in-95 duration-500" style={{
                alignItems: 'center',
                backdropFilter: 'blur(10px)'
              }}
              // onClick={() => setIsOpen(false)}
              >
                <CustomCalendar
                  selectedDate={editBuffer.birthday} // "2002-08-10"
                  onSelect={(newDate) => { setEditBuffer({ ...editBuffer, birthday: newDate }); setIsOpen(false) }}

                />
              </div>
            )}

            {/* EMAIL / RECOVERY / PHONE EDIT + VERIFY */}
            {(editingField === "primaryEmail" || editingField === "recoveryEmail" || editingField === "recoveryPhone") && (
              <div className="space-y-4">
                {/* Step 1: Input Field */}

                <div className="relative">
                  <input
                    type={editingField.includes("Email") ? "email" : "tel"}
                    disabled={isVerifying &&  sendOTPFor == editingField}
                    className={cn(
                      "w-full bg-transparent border-2 border-muted focus:border-sidebar-primary rounded-xl px-4 py-4 outline-none transition-all",
                      isVerifying && sendOTPFor == editingField && "opacity-50 cursor-not-allowed bg-muted/10",
                      // Optional: Add a green border if verified and not currently being edited/dirty
                      user[`${editingField.replace(/([A-Z])/g, '_$1').toLowerCase()}_verified`] && !isDirty && ""
                    )}
                    value={editBuffer[editingField]}
                    onChange={(e) => {
                      setEditBuffer({ ...editBuffer, [editingField]: e.target.value });
                      setIsDirty(true);
                      if (isVerifying) setIsVerifying(false);
                    }}
                  />
                  <label className="absolute left-3 -top-2.5 px-2 bg-card text-xs text-sidebar-primary uppercase flex items-center gap-1">
                    {editingField.replace(/([A-Z])/g, ' $1')}

                    {/* VERIFIED BADGE */}
                    {user[`${editingField.replace(/([A-Z])/g, '_$1').toLowerCase()}_verified`] && !isDirty && (
                      <span className="flex items-center text-[10px] text-green-600 dark:text-green-400 font-bold ml-1">
                        <CheckCircle2 size={10} className="mr-0.5" /> VERIFIED
                      </span>
                    )}
                  </label>
                </div>

                {editBuffer[editingField]?.length > 0 &&
                  !isVerifying &&
                  (!user[`${editingField.replace(/([A-Z])/g, '_$1').toLowerCase()}_verified`] || isDirty) && (
                    <div className="p-4 bg-amber-500/5 rounded-xl border border-dashed border-amber-500/30 flex items-center justify-between animate-in fade-in zoom-in-95">
                      <div className="flex items-center gap-3 text-sm text-amber-700 dark:text-amber-400 font-medium">
                        <AlertCircle size={18} />
                        <span>{isDirty ? "Verify your new details" : `Verify your ${editingField.includes("Email") ? "email" : "phone"}`}</span>
                      </div>
                      <button
                        type="button"
                        onClick={() => handleVerify()}
                        className="text-xs font-bold bg-sidebar-primary text-white px-4 py-2 rounded-lg hover:opacity-90 transition-all"
                      >
                        Authenticate and Save
        </button>
                    </div>
                  )}


                {/* Step 3: OTP Input Section (Only after clicking Verify) */}
                {isVerifying && sendOTPFor == editingField && (
                  <div className="p-6 bg-sidebar-primary/5 rounded-2xl border border-sidebar-primary/20 space-y-4 animate-in slide-in-from-top-4">
                    <div className="text-center space-y-1">
                      <p className="text-sm font-semibold text-foreground">Enter verification code</p>
                      <p className="text-xs text-muted-foreground">
                        {/* A 6-digit code was sent to {editBuffer[editingField]} */}
                         A 6-digit code was sent to {user?.phone_number}
                      </p>
                    </div>

                    <div className="flex justify-center">
                      <input
                        type="text"
                        maxLength={6}
                        placeholder="000000"
                        className="w-40 text-center bg-transparent border-b-2 border-sidebar-primary py-2 text-2xl tracking-[0.5em] font-bold outline-none"
                        value={otp}
                        onChange={(e) => setOtp(e.target.value.replace(/\D/g, ""))}
                      />
                    </div>

                    <div className="flex justify-center gap-4 pt-2">
                      <button
                        type="button"
                        onClick={() => handleChange()}
                        className="text-xs font-medium text-muted-foreground hover:text-foreground"
                      >
                        Change {editingField.includes("Email") ? "Email" : "Phone"}
                      </button>


                      <button
                        type="button"
                        onClick={handleResendClick}
                        disabled={resendCooldown > 0 || isResending}
                        className={`text-xs font-bold transition-all flex items-center gap-2
        ${resendCooldown > 0 || isResending
                            ? "text-muted-foreground cursor-not-allowed"
                            : "text-sidebar-primary hover:underline"
                          }`}
                      >
                        {isResending ? (
                          <>
                            <Loader2 className="animate-spin" size={12} />
                            <span>Sending code...</span>
                          </>
                        ) : resendCooldown > 0 ? (
                          <span>Try again in {resendCooldown}s</span>
                        ) : (
                              "Resend Code"
                            )}
                      </button>

                    </div>
                  </div>
                )}
              </div>
            )}


            {/* NAME EDIT */}
            {editingField === "name" && (
              <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div className="relative">
                  <input className="w-full bg-transparent border-2 border-muted focus:border-sidebar-primary rounded-xl px-4 py-3 outline-none"
                    value={editBuffer.firstName} onChange={(e) => setEditBuffer({ ...editBuffer, firstName: e.target.value })} />
                  <label className="absolute left-3 -top-2.5 px-2 bg-card text-xs text-sidebar-primary">First Name</label>
                </div>
                <div className="relative">
                  <input className="w-full bg-transparent border-2 border-muted focus:border-sidebar-primary rounded-xl px-4 py-3 outline-none"
                    value={editBuffer.lastName} onChange={(e) => setEditBuffer({ ...editBuffer, lastName: e.target.value })} />
                  <label className="absolute left-3 -top-2.5 px-2 bg-card text-xs text-sidebar-primary">Last Name</label>
                </div>
              </div>
            )}

            <div className="flex justify-end gap-3 pt-4 border-t border-border">
              <button disabled={isSaving} onClick={() => { setEditingField(null); closeEdit() }} className="px-5 py-2 text-sm font-semibold text-sidebar-primary">Cancel</button>
              <button
                onClick={handleSave}
                disabled={isSaving}
                className="bg-sidebar-primary text-white px-8 py-2 rounded-lg text-sm font-semibold flex items-center gap-2"
              >
                {isSaving ? <Loader2 size={16} className="animate-spin" /> : "Save"}
              </button>
            </div>
          </div>

          {(showToast) && (
            <div className="fixed z-[51] bottom-8 left-8 bg-[#323232] text-white px-6 py-3 rounded-lg shadow-2xl flex items-center gap-3 animate-in slide-in-from-left-10">
              <CheckCircle2 size={18} className="text-green-400" />
              <span className="text-sm">{toastMsg}</span>
            </div>
          )}
        </div>
      </div>
    );
  }


  if (loading) {
    return (
      <div className="h-screen w-full flex items-center justify-center bg-background">
        <div className="flex flex-col items-center gap-4">
          <Loader2 className="h-8 w-8 animate-spin text-sidebar-primary" />
          <p className="text-muted-foreground animate-pulse">Loading your account...</p>
        </div>
      </div>
    );
  }

  return (
    <div className="max-w-3xl mx-auto pt-8 pb-20 px-4 relative">
      <div className="mb-8">
        <h1 className="text-3xl font-normal mb-2">Personal info</h1>
        <p className="text-sm text-muted-foreground">Manage your identity and contact methods across Indzs.</p>
      </div>


      <div className="bg-background border border-border rounded-2xl overflow-hidden shadow-sm">

        <div className="flex items-center justify-between p-6 hover:bg-accent/30 cursor-pointer transition-colors border-b border-border group">
          <div className="flex items-center gap-6">
            <Camera size={20} className="text-muted-foreground" />
            <span className="text-base font-medium">Profile picture</span>
          </div>
          <div className="w-16 h-16 rounded-full bg-sidebar-primary/20 flex items-center justify-center text-2xl text-sidebar-primary relative overflow-hidden group">
            {profile.firstName.toUpperCase().charAt(0)}
            <div className="absolute inset-0 bg-black/40 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center">
              <Camera size={20} className="text-white" />
            </div>
          </div>
        </div>
        <InfoRow icon={User} label="Name" value={`${profile.firstName} ${profile.lastName}`} onClick={() => startEdit("name")} />

        {/* <div className="bg-muted/5 py-2 px-4 text-[10px] font-bold text-muted-foreground border-b border-border uppercase tracking-widest">Contact Info</div> */}
        <InfoRow
          icon={Mail}
          label="Primary Email"
          value={profile.primaryEmail}
          needsVerification={!profile.primaryEmailVerified}
          onClick={() => startEdit("primaryEmail")}
        />
        <InfoRow
          icon={Mail}
          label="Recovery Email"
          value={profile.recoveryEmail || "Not added"}
          needsVerification={profile.recoveryEmail && !profile.recoveryEmailVerified}
          onClick={() => startEdit("recoveryEmail")}
        />
        <InfoRow icon={Phone} label="Primary Phone" value={profile.primaryPhone} isLocked />
        <InfoRow
          icon={Phone}
          label="Recovery Phone"
          value={profile.recoveryPhone || "None added"}
          needsVerification={profile.recoveryPhone && !profile.recoveryPhoneVerified}
          onClick={() => startEdit("recoveryPhone")}
        />

        {/* <div className="bg-muted/5 py-2 px-4 text-[10px] font-bold text-muted-foreground border-b border-border uppercase tracking-widest">Other</div> */}
        <InfoRow icon={Cake} label="Birthday" value={new Date(profile.birthday).toLocaleDateString('en-GB', { day: 'numeric', month: 'long', year: 'numeric' })} onClick={() => startEdit("birthday")} />
      </div>

      {(showToast) && (
        <div className="fixed z-[51] bottom-8 left-8 bg-[#323232] text-white px-6 py-3 rounded-lg shadow-2xl flex items-center gap-3 animate-in slide-in-from-left-10">
          <CheckCircle2 size={18} className="text-green-400" />
          <span className="text-sm">{toastMsg}</span>
        </div>
      )}
    </div>
  );
}

