import "@/styles/globals.css";
// import type { Metadata } from "next"
// import { Geist, Geist_Mono } from "next/font/google";
import { GeistSans, GeistMono } from "geist/font";
import Providers from "./providers"
import { AuthProvider } from "@/context/AuthContext";
export default function RootLayout({ children }: { children: React.ReactNode }) {


  return (
    <html lang="en" suppressHydrationWarning>
      <head>
        <script
          dangerouslySetInnerHTML={{
            __html: `
              (function() {
                const savedTheme = localStorage.getItem('theme');
                const systemDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
                if (savedTheme === 'dark' || (!savedTheme && systemDark)) {
                  document.documentElement.classList.add('dark');
                } else {
                  document.documentElement.classList.remove('dark');
                }
              })()
            `,
          }}
        />
      </head>
      <body className={`font-sans ${GeistSans.variable} ${GeistMono.variable} bg-background text-foreground antialiased`} >
        {/* <Providers> */}
        <AuthProvider>
          {children}
        </AuthProvider>
        {/* </Providers> */}
      </body>
    </html>
  );
}

// import type { Metadata } from "next";
// import { Inter } from "next/font/google";
// import "@/styles/globals.css";
// import { cn } from "@/lib/utils";

// const inter = Inter({ subsets: ["latin"] });

// export const metadata: Metadata = {
//   title: "Indzs Account",
//   description: "Manage your info, privacy, and security.",
// };

// export default function RootLayout({
//   children,
// }: {
//   children: React.ReactNode;
// }) {
//   return (
//     // The "dark" class here enables your provided OKLCH variables.
//     // In a real app, you'd wrap this in a ThemeProvider.
//     <html lang="en" className="dark">
//       <body
//         className={cn(
//           inter.className,
//           "min-h-screen bg-background text-foreground antialiased"
//         )}
//       >
//         {children}
//       </body>
//     </html>
//   );
// }