import Link from "next/link";
import { ShieldCheck, ArrowRight } from "lucide-react";

export default function RootPage() {
  // In the future, you will check for a session here using NextAuth
  // const session = await getServerSession();
  // if (session) redirect('/dashboard');

  return (
    <div className="flex flex-col items-center justify-center min-h-screen p-6 text-center bg-background">
      <div className="flex items-center gap-2 mb-8">
        <ShieldCheck className="text-primary w-10 h-10" />
        <span className="text-2xl font-semibold">Indzs Account Portal</span>
      </div>

      <h1 className="text-4xl md:text-5xl font-bold mb-6 tracking-tight text-foreground">
        Manage your info, privacy, and security
      </h1>

      <p className="max-w-[600px] text-muted-foreground mb-10">
        Make your experience work better for you. Access your settings and manage your data from one place.
      </p>

      <div className="flex gap-4">
        {/* Redirects to your (dashboard)/dashboard/page.tsx */}
        <Link 
          href="/dashboard" 
          className="px-8 py-3 bg-primary text-primary-foreground font-medium rounded-full hover:opacity-90 transition-all flex items-center"
        >
          Go to Dashboard
          <ArrowRight className="ml-2 w-4 h-4" />
        </Link>

        {/* Redirects to your (auth)/login/page.tsx */}
        <Link 
          href="/login" 
          className="px-8 py-3 border border-border rounded-full hover:bg-accent text-foreground transition-all"
        >
          Sign In
        </Link>
      </div>
    </div>
  );
}