"use client";
import React, { useState, useEffect } from "react";
import { LucideIcon, ChevronRight, Lock, AlertCircle, Loader2 } from "lucide-react";
import { cn } from "@/lib/utils";
import { getCountry } from '@/lib/country-data';

interface InfoRowProps {
  icon: LucideIcon;
  label: string;
  value: string;
  subValue?: string;
  onClick?: () => void;
  isLocked?: boolean;
  isLoading?: boolean;
  needsVerification?: boolean;
  countryCode?: string | null;
}

const InfoRow: React.FC<InfoRowProps> = ({
  icon: Icon,
  label,
  value,
  subValue,
  onClick,
  isLocked = false,
  isLoading = false,
  needsVerification = false,
  countryCode = null,
}) => {
  const [isPressed, setIsPressed] = useState(false);
  // Type this based on what getCountry returns (e.g., any or a specific interface)
  const [country, setCountry] = useState<any>(null);

  // Use useEffect to update state based on props to avoid infinite re-renders
  useEffect(() => {
    if (countryCode) {
      const data = getCountry(countryCode);
      setCountry(data);
    }
  }, [countryCode]);

  const handlePress = () => {
    if (isLocked || isLoading || !onClick) return;

    setIsPressed(true);
    onClick();

    setTimeout(() => setIsPressed(false), 200);
  };

  // Use the state 'country' or fallback to the function logic
  const callingCode = country?.dial ? `+${country.dial}` : "";

  return (
    <div
      onClick={handlePress}
      className={cn(
        "flex items-center justify-between p-4 transition-all border-b border-border last:border-0 group",
        (isLocked || isLoading) ? "bg-muted/5 cursor-not-allowed" : "hover:bg-accent/40 cursor-pointer",
        isPressed && "bg-accent scale-[0.99]"
      )}
    >
      <div className="flex items-center gap-6">
        <div className="text-muted-foreground min-w-[24px]">
          {isLoading ? (
            <Loader2 size={18} className="animate-spin" />
          ) : isLocked ? (
            <Lock size={18} className="opacity-50" />
          ) : (
                <Icon size={20} />
              )}
        </div>

        <div className="flex flex-col">
          <div className="flex items-center gap-2">
            <span className="text-[11px] font-bold text-muted-foreground uppercase tracking-wider">
              {label}
            </span>
            {needsVerification && !isLoading && (
              <span className="flex items-center gap-1 text-[10px] font-bold text-amber-600 dark:text-amber-400 bg-amber-500/10 px-1.5 py-0.5 rounded uppercase">
                <AlertCircle size={10} /> Unverified
              </span>
            )}
          </div>

          <div className="text-base flex gap-2 text-foreground mt-0.5">
            {countryCode && value !== "None added" && callingCode && (
              <span className="mr-1 font-medium text-muted-foreground">
                <div className="flex items-center gap-2" style={{ alignItems: "center" }}>
                  <img src={country.flag_icon} width="20" alt="IN" className="mt-[6px]" />
                  <span className="mt-[1px]" >+{country.dial}</span>
                </div>
              </span>
            )}
            <span className={cn(isLoading && "opacity-50")}>{value}</span>
          </div>

          {subValue && (
            <span className="text-sm text-muted-foreground">{subValue}</span>
          )}
        </div>
      </div>

      <div className="flex items-center">
        {!isLocked && !isLoading && (
          <ChevronRight
            size={20}
            className="text-muted-foreground group-hover:translate-x-1 transition-transform"
          />
        )}
      </div>
    </div>
  );
};

export default InfoRow;
// "use client";
// import { useState, useEffect, useRef } from "react";
// import {
//   Camera, User, Mail, Phone, Cake, Languages, ChevronRight,
//   ArrowLeft, CheckCircle2, Loader2, Lock, AlertCircle, Calendar,
// } from "lucide-react";
// import { cn } from "@/lib/utils";
// import {getCountry} from '@/lib/country-data'


// const InfoRow = ({ icon: Icon, label, value, subValue, onClick, isLocked, needsVerification, countryCode = null }: any) => (



//   <div
//     onClick={!isLocked ? onClick : undefined}
//     className={cn(
//       "flex items-center justify-between p-4 transition-colors border-b border-border last:border-0 group",
//       isLocked ? "bg-muted/5 cursor-not-allowed" : "hover:bg-accent/40 cursor-pointer"
//     )}
//   >
//     <div className="flex items-center gap-6">
//       <div className="text-muted-foreground min-w-[24px]">
//         {isLocked ? <Lock size={18} className="opacity-50" /> : <Icon size={20} />}
//       </div>
//       <div className="flex flex-col">
//         <div className="flex items-center gap-2">
//           <span className="text-[11px] font-bold text-muted-foreground uppercase tracking-wider">{label}</span>
//           {needsVerification && (
//             <span className="flex items-center gap-1 text-[10px] font-bold text-amber-600 dark:text-amber-400 bg-amber-500/10 px-1.5 py-0.5 rounded uppercase">
//               <AlertCircle size={10} /> Unverified
//             </span>
//           )}
//         </div>
//         <span>
//           {countryCode && value!="None added" && <span className="text-base text-foreground mt-0.5">+{()=>{console.log(getCountry(countryCode)); return "91" }} </span>}
//           <span className="text-base text-foreground mt-0.5">{value}</span>
//         </span>
//         {subValue && <span className="text-sm text-muted-foreground">{subValue}</span>}
//       </div>
//     </div>
//     {!isLocked && <ChevronRight size={20} className="text-muted-foreground group-hover:translate-x-1 transition-transform" />}
//   </div>
// );

// export default InfoRow