"use client";
import { Search, HelpCircle, Grid, Menu, Sun, Moon } from "lucide-react";
import { cn } from "@/lib/utils";
import { useTheme } from "@/hooks/useTheme";
import { useState, useRef, useEffect } from "react";
import { User, Shield, Link2, Database, X, ChevronRight, Loader2 } from "lucide-react";
import { SETTINGS_MAP } from "@/lib/search-data";
import GlobalSearch from "@/components/Search/GlobalSearch";
import AccountSwitcher from '@/components/nav/AccountSwitcher'
import NineDotMenu from '@/components/nav/NineDotMenu'

import { Logo } from "@/components/ui/Logo"
// import { cn } from "@/lib/utils";
import Link from "next/link";


const mainUser = {
  email: "anandagopaldutta1@gmail.com",
  name: "Ananda Gopal"
};
const ICON_COMPONENTS: any = { User, Shield, Link2, Database };

interface NavbarProps {
  onMenuClick: () => void;
}

export const BasicNavbar = ({ onMenuClick }: { onMenuClick: () => void }) => {
  const { theme, toggleTheme } = useTheme();
  const [query, setQuery] = useState("");
  const [results, setResults] = useState<any[]>([]);
  const [isOpen, setIsOpen] = useState(false);
  const [isSearching, setIsSearching] = useState(false);
  const containerRef = useRef<HTMLDivElement>(null);


  // --- Debounce Logic ---
  useEffect(() => {
    // If query is empty, clear results immediately
    if (!query.trim()) {
      setResults([]);
      setIsOpen(false);
      setIsSearching(false);
      return;
    }

    setIsSearching(true);

    const timer = setTimeout(() => {
      const filtered = SETTINGS_MAP.filter(item =>
        item.title.toLowerCase().includes(query.toLowerCase()) ||
        item.keywords.some(k => k.toLowerCase().includes(query.toLowerCase()))
      );

      setResults(filtered);
      setIsSearching(false);
      setIsOpen(true);
    }, 400); // 400ms delay: perfect balance between snappy and efficient

    return () => clearTimeout(timer);
  }, [query]);

  // Close dropdown on click outside
  useEffect(() => {
    const handleClick = (e: MouseEvent) => {
      if (containerRef.current && !containerRef.current.contains(e.target as Node)) {
        setIsOpen(false);
      }
    };
    document.addEventListener("mousedown", handleClick);
    return () => document.removeEventListener("mousedown", handleClick);
  }, []);

  return (
    <header className="fixed justify-between top-0 left-0 right-0 h-18 bg-background border-b border-border flex items-center px-4 z-50">
      <div className="flex items-center gap-2 min-w-[10px] lg:min-w-[240px]">
        {/* Mobile Hamburger - visible on small screens */}
        <button
          onClick={onMenuClick}
          className="p-2 hover:bg-accent rounded-full md:hidden text-foreground"
        >
          <Menu size={20} />
        </button>
        <span className="text-xl font-normal text-foreground px-2 hidden sm:block">
          <div className="flex align-middle justify-center gap-[10px]" style={{ alignItems: 'center' }}>
            <Logo />
            <span className="text-2xl text-muted-foreground/80 font-light">Account</span>
          </div>
        </span>
      </div>


      <div className="flex items-center gap-1">
        {/* Theme Toggle Button */}
        <button
          onClick={toggleTheme}
          className="p-2 hover:bg-accent rounded-full text-muted-foreground transition-colors"
        >
          {theme === "dark" ? <Sun size={20} /> : <Moon size={20} />}
        </button>

        {/* className="hidden sm:flex p-2 hover:bg-accent rounded-full text-muted-foreground" */}
        <button className="flex hover:bg-accent rounded-full text-muted-foreground">
          {/* <Grid size={20} /> */}
          <NineDotMenu />
        </button>

        <AccountSwitcher
          primaryAccount={mainUser}
          theme={theme}
          toggleTheme={toggleTheme}
        />
      </div>
    </header>
  );
};


