import React from 'react';
import Link from 'next/link';

interface FooterLink {
  label: string;
  href: string;
}

const PrivacyPolicyFooter = ({ justify = "justify-between", className = "" }) => {
  const links = [
    { label: "Help", href: "/help" },
    { label: "Privacy", href: "/privacy" },
    { label: "Terms", href: "/terms" }
  ]

  return (
    <footer className={`w-full px-8 py-6 flex items-center ${justify} ${className}`}>
      {/* Left Side: Language Selector */}
      <div className="relative">
        {/* <select 
          className="appearance-none bg-[#202124] text-[#e8eaed] text-sm py-2 pl-4 pr-10 rounded-md cursor-pointer border border-transparent hover:bg-[#28292c] transition-colors focus:outline-none"
          defaultValue="en-us"
        >
          <option value="en-us">English (United States)</option>
          <option value="uk">English (United Kingdom)</option>
          <option value="es">Español</option>
        </select> */}
        {/* Custom Arrow Icon */}
        {/* <div className="pointer-events-none absolute inset-y-0 right-0 flex items-center px-3 text-[#e8eaed]">
          <svg className="fill-current h-4 w-4" viewBox="0 0 20 20">
            <path d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" />
          </svg>
        </div> */}
      </div>

      {/* Right Side: Links */}
      <nav className="flex gap-6">
        {links.map((link, index) => (
          <Link
            key={index}
            href={link.href}
            className="text-[#bdc1c6] text-xs md:text-sm hover:text-primary transition-colors"
          >
            {link.label}
          </Link>
        ))}
      </nav>
    </footer>
  );
};

export default PrivacyPolicyFooter;












// import React from "react";
// import { Bell, ExternalLink } from "lucide-react";
// import { cn } from "@/lib/utils";

// interface HelpHeaderProps {
//   className?: string;
//   justify?: "justify-between" | "justify-start" | "justify-end" | "justify-around";
// }

// export const HelpHeader = ({ className, justify = "justify-between" }: HelpHeaderProps) => {
//   return (
//     <nav className={cn(
//       "flex items-center w-full px-6 py-4 bg-[#0f0f0f] border-b border-white/10 text-white text-sm font-medium",
//       justify,
//       className
//     )}>
//       {/* Left Section: Tabs */}
//       <div className="flex items-center gap-8">
//         <div className="relative pb-4 -mb-4 border-b-2 border-primary cursor-pointer">
//           Help Center
//         </div>
//         <div className="text-gray-400 hover:text-white cursor-pointer transition-colors">
//           Community
//         </div>
//         <div className="text-gray-400 hover:text-white cursor-pointer transition-colors hidden md:block">
//           Improve your Account
//         </div>
//       </div>

//       {/* Right Section: Actions */}
//       <div className="flex items-center gap-6 text-gray-400">
//         <button className="hover:text-white transition-colors">
//           <Bell size={20} />
//         </button>
//         <button className="flex items-center gap-2 hover:text-white transition-colors">
//           <span>Google Search</span>
//           <ExternalLink size={16} />
//         </button>
//         <div className="w-8 h-8 rounded-full bg-gradient-to-tr from-blue-500 to-purple-500 border border-white/20" />
//       </div>
//     </nav>
//   );
// };