"use client";
import { useState, useEffect, useCallback } from "react";
import { 
  Search, UserPlus, Shield, UserMinus, Trash2, 
  Edit3, Filter, ChevronLeft, ChevronRight, X 
} from "lucide-react";
import { cn } from "@/lib/utils";
const AlertModal = ({ 
  isOpen, 
  onClose, 
  onConfirm, 
  title, 
  description, 
  variant = "danger", 
  confirmText = "Confirm",
  children 
}: any) => {
  if (!isOpen) return null;

  return (
    <div className="fixed inset-0 bg-black/60 backdrop-blur-sm flex items-center justify-center z-[100] p-4 animate-in fade-in duration-200">
      <div className="bg-background border border-border rounded-3xl p-6 max-w-md w-full shadow-2xl space-y-4 transform animate-in zoom-in-95 duration-200">
        <div className="flex justify-between items-center">
          <h3 className="text-xl font-bold tracking-tight">{title}</h3>
          <button onClick={onClose} className="p-1 hover:bg-secondary rounded-full transition-colors">
            <X size={20} />
          </button>
        </div>
        
        {description && <p className="text-muted-foreground text-sm leading-relaxed">{description}</p>}
        
        <div className="py-2">{children}</div>

        <div className="flex gap-3 pt-2">
          <button 
            onClick={onClose}
            className="flex-1 py-2.5 text-sm font-semibold text-muted-foreground hover:bg-secondary rounded-xl transition-colors"
          >
            Cancel
          </button>
          <button 
            onClick={onConfirm}
            className={cn(
              "flex-1 py-2.5 text-sm font-semibold text-white rounded-xl transition-all hover:opacity-90",
              variant === "danger" ? "bg-rose-600 shadow-lg shadow-rose-600/20" : "bg-primary shadow-lg shadow-primary/20",
              variant === "warning" ? "bg-amber-500 shadow-lg shadow-amber-500/20" : ""
            )}
          >
            {confirmText}
          </button>
        </div>
      </div>
    </div>
  );
};

export default AlertModal