import React from 'react';
import { cn } from "@/lib/utils"; 

interface LogoProps {
  size?: 'xs' | 'sm' | 'md' | 'lg' | 'xl';
  variant?: 'text' | 'image';
  src?: string; // Future-proofing for image logos
  className?: string;
}

export const Logo = ({ 
  size = 'md', 
  variant = 'text', 
  src, 
  className 
}: LogoProps) => {
  
  // 1. Define Size Mapping
  const sizeMap = {
    xs: "text-lg leading-none",
    sm: "text-xl leading-none",
    md: "text-2xl leading-none",
    lg: "text-4xl leading-tight",
    xl: "text-6xl leading-tight",
  };

  // 2. Define Image Dimensions based on size
  const imgSizeMap = {
    xs: "h-4",
    sm: "h-6",
    md: "h-8",
    lg: "h-12",
    xl: "h-20",
  };

  return (
    <div className={cn("inline-flex items-center select-none", className)}>
      {variant === 'text' || !src ? (
        <div className={cn("font-bold tracking-tighter", sizeMap[size])}>
          <span className="text-[#4285F4]">I</span>
          <span className="text-[#EA4335]">n</span>
          <span className="text-[#FBBC05]">d</span>
          <span className="text-[#34A853]">z</span>
          <span className="text-[#4285F4]">s</span>
        </div>
      ) : (
        <img 
          src={src} 
          alt="Indzs Logo" 
          className={cn("object-contain", imgSizeMap[size])} 
        />
      )}
    </div>
  );
};