import React, { useEffect } from 'react';
import { CheckCircle2, AlertCircle, X } from 'lucide-react';
import { cn } from "@/lib/utils"; 

interface ToastProps {
  message: string;
  type: 'success' | 'error';
  onClose: () => void;
  duration?: number;
}

export const Toast = ({ message, type, onClose, duration = 5000 }: ToastProps) => {
  // Auto-hide logic
  useEffect(() => {
    const timer = setTimeout(onClose, duration);
    return () => clearTimeout(timer);
  }, [onClose, duration]);

  return (
    <div className={cn(
      "fixed z-50 bottom-8 left-1/2 -translate-x-1/2 flex items-center gap-3 px-5 py-3.5 rounded-xl shadow-2xl border animate-in fade-in slide-in-from-bottom-5 duration-300",
      type === 'success' 
        ? "bg-emerald-600 border-emerald-500 text-white" 
        : "bg-destructive border-red-400 text-white"
    )}>
      {type === 'success' ? <CheckCircle2 size={18} /> : <AlertCircle size={18} />}
      
      <span className="text-sm font-semibold tracking-wide">{message}</span>
      
      <button 
        onClick={onClose} 
        className="ml-2 hover:bg-white/20 rounded-full p-1 transition-colors"
        aria-label="Close notification"
      >
        <X size={14} />
      </button>
    </div>
  );
};