"use client";
import { useEffect, useState } from "react";

export function useTheme() {
  // Initialize state with null or a placeholder to avoid hydration mismatch
  const [theme, setTheme] = useState<"light" | "dark" | null>(null);

  useEffect(() => {
    // Access localStorage only after component mounts on client
    const savedTheme = localStorage.getItem("theme") as "light" | "dark";
    const systemTheme = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light";
    
    const initialTheme = savedTheme || systemTheme;
    setTheme(initialTheme);
    document.documentElement.classList.toggle("dark", initialTheme === "dark");
  }, []);

  const toggleTheme = () => {
    const newTheme = theme === "dark" ? "light" : "dark";
    setTheme(newTheme);
    localStorage.setItem("theme", newTheme);
    document.documentElement.classList.toggle("dark", newTheme === "dark");
  };

  return { theme, toggleTheme };
}