import Cookies from "js-cookie";

export async function apiFetch(url: string, options: any = {}) {
    let accessToken = Cookies.get("access_token");
    console.log(accessToken)
    const headers = {
        ...options.headers,
        "Content-Type": "application/json",
        ...(accessToken ? { Authorization: `Bearer ${accessToken}` } : {}),
    };

    let response = await fetch(url, { ...options, headers });

    // If Token Expired
    if (response.status === 401) {
        const refreshToken = Cookies.get("refresh_token");
        if (!refreshToken) return response;

        // Call Refresh Route
        const refreshRes = await fetch(`${process.env.NEXT_PUBLIC_API_BASE_URL}/api/auth/refresh/`, {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ refresh: refreshToken }),
        });

        if (refreshRes.ok) {
            const data = await refreshRes.json();
            const newAccess = data.access;

            // Save new token
            Cookies.set("access_token", newAccess, { expires: 1 / 24 });

            // Retry original request
            headers["Authorization"] = `Bearer ${newAccess}`;
            return fetch(url, { ...options, headers });
        } else {
            // Refresh failed, clear everything
            Cookies.remove("access_token");
            Cookies.remove("refresh_token");
            window.location.href = "/login";
        }
    }

    return response;
}