export const validateStep = (step: number, data: any) => {
  switch (step) {
    case 1: // Name Step
      if (!data.firstName || data.firstName.trim().length < 2) {
        return "Enter a valid first name";
      }
      return "";

    case 2: // Phone Step
      const phoneRegex = /^[0-9]{10}$/; 
      if (!data.phone) return "Phone number is required";
      if (!phoneRegex.test(data.phone)) return "Enter a valid 10-digit phone number";
      return "";

    case 3: // Email Step
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (!data.email) return "Email address is required";
      if (!emailRegex.test(data.email)) return "Enter a valid email address";
      return "";

    case 4: // Password Step
      if (!data.password || data.password.length < 8) {
        return "Password must be at least 8 characters";
      }
      if (data.password !== data.confirmPassword) {
        return "Passwords didn't match. Try again.";
      }
      return "";

    case 5: // OTP Step (Final)
      if (!data.otp || data.otp.length !== 6 || isNaN(Number(data.otp))) {
        return "Enter the 6-digit verification code";
      }
      return "";

    default:
      return "";
  }
};




export const validateFindEmail = (step: number, data: any) => {
  switch (step) {
    case 1: // Recovery Identifier
      if (!data.recoveryInput) return "Enter a recovery phone or email";
      return "";
    case 2: // Name Verification (Security check)
      if (!data.firstName.trim()) return "Enter first name";
      return "";
    case 3: // OTP
      if (data.otp.length !== 6) return "Enter 6-digit code";
      return "";
    default:
      return "";
  }
};


export const authPaths = {
    forgotEmail: "/forgot-email",
    forgotPassword: "/forgot-password",
    login: "/login",
    register: "/register"
};


export const validateProfileUpdate = (field: string, value: any) => {
  if (field === "name") {
    if (!value.firstName.trim()) return "First name is required";
  }
  if (field === "recoveryEmail") {
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (value && !emailRegex.test(value)) return "Enter a valid email address";
  }
  return "";
};





export const validateForgotPass = (step: number, formData: any) => {
  if (step === 1 && !formData.identifier) return "Please enter an email or phone number.";
  if (step === 2 && formData.otp.length !== 6) return "Enter a valid 6-digit code.";
  if (step === 3) {
    if (formData.password.length < 8) return "Password must be at least 8 characters.";
    if (formData.password !== formData.confirmPassword) return "Passwords do not match.";
  }
  return null;
};




export const validateIdentifier = (input: string) => {
  const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  const phoneRegex = /^\+?[1-9]\d{1,14}$/; // International E.164 format

  if (!input) return "Email or phone is required.";
  if (input.includes("@")) {
    if (!emailRegex.test(input)) return "Please enter a valid email address.";
  } else {
    input = input.split("-").reverse()[0]
    if (!phoneRegex.test(input)) return "Please enter a valid phone number with country code.";
  }
  return null;
};