export interface Country {
  name: string;
  code: string;
  dial: string;
  flag: string;
  flag_icon :string
}

export const COUNTRIES: Country[] = [
    {
        "name": "Afghanistan",
        "code": "AF",
        "dial": "93",
        "flag": "🇦🇫",
        "flag_icon": "https://flagcdn.com/w20/af.png"
    },
    {
        "name": "Aland Islands",
        "code": "AX",
        "dial": "358",
        "flag": "🇦🇽",
        "flag_icon": "https://flagcdn.com/w20/ax.png"
    },
    {
        "name": "Albania",
        "code": "AL",
        "dial": "355",
        "flag": "🇦🇱",
        "flag_icon": "https://flagcdn.com/w20/al.png"
    },
    {
        "name": "Algeria",
        "code": "DZ",
        "dial": "213",
        "flag": "🇩🇿",
        "flag_icon": "https://flagcdn.com/w20/dz.png"
    },
    {
        "name": "AmericanSamoa",
        "code": "AS",
        "dial": "1684",
        "flag": "🇦🇸",
        "flag_icon": "https://flagcdn.com/w20/as.png"
    },
    {
        "name": "Andorra",
        "code": "AD",
        "dial": "376",
        "flag": "🇦🇩",
        "flag_icon": "https://flagcdn.com/w20/ad.png"
    },
    {
        "name": "Angola",
        "code": "AO",
        "dial": "244",
        "flag": "🇦🇴",
        "flag_icon": "https://flagcdn.com/w20/ao.png"
    },
    {
        "name": "Anguilla",
        "code": "AI",
        "dial": "1264",
        "flag": "🇦🇮",
        "flag_icon": "https://flagcdn.com/w20/ai.png"
    },
    {
        "name": "Antarctica",
        "code": "AQ",
        "dial": "672",
        "flag": "🇦🇶",
        "flag_icon": "https://flagcdn.com/w20/aq.png"
    },
    {
        "name": "Antigua and Barbuda",
        "code": "AG",
        "dial": "1268",
        "flag": "🇦🇬",
        "flag_icon": "https://flagcdn.com/w20/ag.png"
    },
    {
        "name": "Argentina",
        "code": "AR",
        "dial": "54",
        "flag": "🇦🇷",
        "flag_icon": "https://flagcdn.com/w20/ar.png"
    },
    {
        "name": "Armenia",
        "code": "AM",
        "dial": "374",
        "flag": "🇦🇲",
        "flag_icon": "https://flagcdn.com/w20/am.png"
    },
    {
        "name": "Aruba",
        "code": "AW",
        "dial": "297",
        "flag": "🇦🇼",
        "flag_icon": "https://flagcdn.com/w20/aw.png"
    },
    {
        "name": "Australia",
        "code": "AU",
        "dial": "61",
        "flag": "🇦🇺",
        "flag_icon": "https://flagcdn.com/w20/au.png"
    },
    {
        "name": "Austria",
        "code": "AT",
        "dial": "43",
        "flag": "🇦🇹",
        "flag_icon": "https://flagcdn.com/w20/at.png"
    },
    {
        "name": "Azerbaijan",
        "code": "AZ",
        "dial": "994",
        "flag": "🇦🇿",
        "flag_icon": "https://flagcdn.com/w20/az.png"
    },
    {
        "name": "Bahamas",
        "code": "BS",
        "dial": "1242",
        "flag": "🇧🇸",
        "flag_icon": "https://flagcdn.com/w20/bs.png"
    },
    {
        "name": "Bahrain",
        "code": "BH",
        "dial": "973",
        "flag": "🇧🇭",
        "flag_icon": "https://flagcdn.com/w20/bh.png"
    },
    {
        "name": "Bangladesh",
        "code": "BD",
        "dial": "880",
        "flag": "🇧🇩",
        "flag_icon": "https://flagcdn.com/w20/bd.png"
    },
    {
        "name": "Barbados",
        "code": "BB",
        "dial": "1246",
        "flag": "🇧🇧",
        "flag_icon": "https://flagcdn.com/w20/bb.png"
    },
    {
        "name": "Belarus",
        "code": "BY",
        "dial": "375",
        "flag": "🇧🇾",
        "flag_icon": "https://flagcdn.com/w20/by.png"
    },
    {
        "name": "Belgium",
        "code": "BE",
        "dial": "32",
        "flag": "🇧🇪",
        "flag_icon": "https://flagcdn.com/w20/be.png"
    },
    {
        "name": "Belize",
        "code": "BZ",
        "dial": "501",
        "flag": "🇧🇿",
        "flag_icon": "https://flagcdn.com/w20/bz.png"
    },
    {
        "name": "Benin",
        "code": "BJ",
        "dial": "229",
        "flag": "🇧🇯",
        "flag_icon": "https://flagcdn.com/w20/bj.png"
    },
    {
        "name": "Bermuda",
        "code": "BM",
        "dial": "1441",
        "flag": "🇧🇲",
        "flag_icon": "https://flagcdn.com/w20/bm.png"
    },
    {
        "name": "Bhutan",
        "code": "BT",
        "dial": "975",
        "flag": "🇧🇹",
        "flag_icon": "https://flagcdn.com/w20/bt.png"
    },
    {
        "name": "Bolivia, Plurinational State of",
        "code": "BO",
        "dial": "591",
        "flag": "🇧🇴",
        "flag_icon": "https://flagcdn.com/w20/bo.png"
    },
    {
        "name": "Bosnia and Herzegovina",
        "code": "BA",
        "dial": "387",
        "flag": "🇧🇦",
        "flag_icon": "https://flagcdn.com/w20/ba.png"
    },
    {
        "name": "Botswana",
        "code": "BW",
        "dial": "267",
        "flag": "🇧🇼",
        "flag_icon": "https://flagcdn.com/w20/bw.png"
    },
    {
        "name": "Brazil",
        "code": "BR",
        "dial": "55",
        "flag": "🇧🇷",
        "flag_icon": "https://flagcdn.com/w20/br.png"
    },
    {
        "name": "British Indian Ocean Territory",
        "code": "IO",
        "dial": "246",
        "flag": "🇮🇴",
        "flag_icon": "https://flagcdn.com/w20/io.png"
    },
    {
        "name": "Brunei Darussalam",
        "code": "BN",
        "dial": "673",
        "flag": "🇧🇳",
        "flag_icon": "https://flagcdn.com/w20/bn.png"
    },
    {
        "name": "Bulgaria",
        "code": "BG",
        "dial": "359",
        "flag": "🇧🇬",
        "flag_icon": "https://flagcdn.com/w20/bg.png"
    },
    {
        "name": "Burkina Faso",
        "code": "BF",
        "dial": "226",
        "flag": "🇧🇫",
        "flag_icon": "https://flagcdn.com/w20/bf.png"
    },
    {
        "name": "Burundi",
        "code": "BI",
        "dial": "257",
        "flag": "🇧🇮",
        "flag_icon": "https://flagcdn.com/w20/bi.png"
    },
    {
        "name": "Cambodia",
        "code": "KH",
        "dial": "855",
        "flag": "🇰🇭",
        "flag_icon": "https://flagcdn.com/w20/kh.png"
    },
    {
        "name": "Cameroon",
        "code": "CM",
        "dial": "237",
        "flag": "🇨🇲",
        "flag_icon": "https://flagcdn.com/w20/cm.png"
    },
    {
        "name": "Canada",
        "code": "CA",
        "dial": "1",
        "flag": "🇨🇦",
        "flag_icon": "https://flagcdn.com/w20/ca.png"
    },
    {
        "name": "Cape Verde",
        "code": "CV",
        "dial": "238",
        "flag": "🇨🇻",
        "flag_icon": "https://flagcdn.com/w20/cv.png"
    },
    {
        "name": "Cayman Islands",
        "code": "KY",
        "dial": " 345",
        "flag": "🇰🇾",
        "flag_icon": "https://flagcdn.com/w20/ky.png"
    },
    {
        "name": "Central African Republic",
        "code": "CF",
        "dial": "236",
        "flag": "🇨🇫",
        "flag_icon": "https://flagcdn.com/w20/cf.png"
    },
    {
        "name": "Chad",
        "code": "TD",
        "dial": "235",
        "flag": "🇹🇩",
        "flag_icon": "https://flagcdn.com/w20/td.png"
    },
    {
        "name": "Chile",
        "code": "CL",
        "dial": "56",
        "flag": "🇨🇱",
        "flag_icon": "https://flagcdn.com/w20/cl.png"
    },
    {
        "name": "China",
        "code": "CN",
        "dial": "86",
        "flag": "🇨🇳",
        "flag_icon": "https://flagcdn.com/w20/cn.png"
    },
    {
        "name": "Christmas Island",
        "code": "CX",
        "dial": "61",
        "flag": "🇨🇽",
        "flag_icon": "https://flagcdn.com/w20/cx.png"
    },
    {
        "name": "Cocos (Keeling) Islands",
        "code": "CC",
        "dial": "61",
        "flag": "🇨🇨",
        "flag_icon": "https://flagcdn.com/w20/cc.png"
    },
    {
        "name": "Colombia",
        "code": "CO",
        "dial": "57",
        "flag": "🇨🇴",
        "flag_icon": "https://flagcdn.com/w20/co.png"
    },
    {
        "name": "Comoros",
        "code": "KM",
        "dial": "269",
        "flag": "🇰🇲",
        "flag_icon": "https://flagcdn.com/w20/km.png"
    },
    {
        "name": "Congo",
        "code": "CG",
        "dial": "242",
        "flag": "🇨🇬",
        "flag_icon": "https://flagcdn.com/w20/cg.png"
    },
    {
        "name": "Congo, The Democratic Republic of the Congo",
        "code": "CD",
        "dial": "243",
        "flag": "🇨🇩",
        "flag_icon": "https://flagcdn.com/w20/cd.png"
    },
    {
        "name": "Cook Islands",
        "code": "CK",
        "dial": "682",
        "flag": "🇨🇰",
        "flag_icon": "https://flagcdn.com/w20/ck.png"
    },
    {
        "name": "Costa Rica",
        "code": "CR",
        "dial": "506",
        "flag": "🇨🇷",
        "flag_icon": "https://flagcdn.com/w20/cr.png"
    },
    {
        "name": "Cote d'Ivoire",
        "code": "CI",
        "dial": "225",
        "flag": "🇨🇮",
        "flag_icon": "https://flagcdn.com/w20/ci.png"
    },
    {
        "name": "Croatia",
        "code": "HR",
        "dial": "385",
        "flag": "🇭🇷",
        "flag_icon": "https://flagcdn.com/w20/hr.png"
    },
    {
        "name": "Cuba",
        "code": "CU",
        "dial": "53",
        "flag": "🇨🇺",
        "flag_icon": "https://flagcdn.com/w20/cu.png"
    },
    {
        "name": "Cyprus",
        "code": "CY",
        "dial": "357",
        "flag": "🇨🇾",
        "flag_icon": "https://flagcdn.com/w20/cy.png"
    },
    {
        "name": "Czech Republic",
        "code": "CZ",
        "dial": "420",
        "flag": "🇨🇿",
        "flag_icon": "https://flagcdn.com/w20/cz.png"
    },
    {
        "name": "Denmark",
        "code": "DK",
        "dial": "45",
        "flag": "🇩🇰",
        "flag_icon": "https://flagcdn.com/w20/dk.png"
    },
    {
        "name": "Djibouti",
        "code": "DJ",
        "dial": "253",
        "flag": "🇩🇯",
        "flag_icon": "https://flagcdn.com/w20/dj.png"
    },
    {
        "name": "Dominica",
        "code": "DM",
        "dial": "1767",
        "flag": "🇩🇲",
        "flag_icon": "https://flagcdn.com/w20/dm.png"
    },
    {
        "name": "Dominican Republic",
        "code": "DO",
        "dial": "1849",
        "flag": "🇩🇴",
        "flag_icon": "https://flagcdn.com/w20/do.png"
    },
    {
        "name": "Ecuador",
        "code": "EC",
        "dial": "593",
        "flag": "🇪🇨",
        "flag_icon": "https://flagcdn.com/w20/ec.png"
    },
    {
        "name": "Egypt",
        "code": "EG",
        "dial": "20",
        "flag": "🇪🇬",
        "flag_icon": "https://flagcdn.com/w20/eg.png"
    },
    {
        "name": "El Salvador",
        "code": "SV",
        "dial": "503",
        "flag": "🇸🇻",
        "flag_icon": "https://flagcdn.com/w20/sv.png"
    },
    {
        "name": "Equatorial Guinea",
        "code": "GQ",
        "dial": "240",
        "flag": "🇬🇶",
        "flag_icon": "https://flagcdn.com/w20/gq.png"
    },
    {
        "name": "Eritrea",
        "code": "ER",
        "dial": "291",
        "flag": "🇪🇷",
        "flag_icon": "https://flagcdn.com/w20/er.png"
    },
    {
        "name": "Estonia",
        "code": "EE",
        "dial": "372",
        "flag": "🇪🇪",
        "flag_icon": "https://flagcdn.com/w20/ee.png"
    },
    {
        "name": "Ethiopia",
        "code": "ET",
        "dial": "251",
        "flag": "🇪🇹",
        "flag_icon": "https://flagcdn.com/w20/et.png"
    },
    {
        "name": "Falkland Islands (Malvinas)",
        "code": "FK",
        "dial": "500",
        "flag": "🇫🇰",
        "flag_icon": "https://flagcdn.com/w20/fk.png"
    },
    {
        "name": "Faroe Islands",
        "code": "FO",
        "dial": "298",
        "flag": "🇫🇴",
        "flag_icon": "https://flagcdn.com/w20/fo.png"
    },
    {
        "name": "Fiji",
        "code": "FJ",
        "dial": "679",
        "flag": "🇫🇯",
        "flag_icon": "https://flagcdn.com/w20/fj.png"
    },
    {
        "name": "Finland",
        "code": "FI",
        "dial": "358",
        "flag": "🇫🇮",
        "flag_icon": "https://flagcdn.com/w20/fi.png"
    },
    {
        "name": "France",
        "code": "FR",
        "dial": "33",
        "flag": "🇫🇷",
        "flag_icon": "https://flagcdn.com/w20/fr.png"
    },
    {
        "name": "French Guiana",
        "code": "GF",
        "dial": "594",
        "flag": "🇬🇫",
        "flag_icon": "https://flagcdn.com/w20/gf.png"
    },
    {
        "name": "French Polynesia",
        "code": "PF",
        "dial": "689",
        "flag": "🇵🇫",
        "flag_icon": "https://flagcdn.com/w20/pf.png"
    },
    {
        "name": "Gabon",
        "code": "GA",
        "dial": "241",
        "flag": "🇬🇦",
        "flag_icon": "https://flagcdn.com/w20/ga.png"
    },
    {
        "name": "Gambia",
        "code": "GM",
        "dial": "220",
        "flag": "🇬🇲",
        "flag_icon": "https://flagcdn.com/w20/gm.png"
    },
    {
        "name": "Georgia",
        "code": "GE",
        "dial": "995",
        "flag": "🇬🇪",
        "flag_icon": "https://flagcdn.com/w20/ge.png"
    },
    {
        "name": "Germany",
        "code": "DE",
        "dial": "49",
        "flag": "🇩🇪",
        "flag_icon": "https://flagcdn.com/w20/de.png"
    },
    {
        "name": "Ghana",
        "code": "GH",
        "dial": "233",
        "flag": "🇬🇭",
        "flag_icon": "https://flagcdn.com/w20/gh.png"
    },
    {
        "name": "Gibraltar",
        "code": "GI",
        "dial": "350",
        "flag": "🇬🇮",
        "flag_icon": "https://flagcdn.com/w20/gi.png"
    },
    {
        "name": "Greece",
        "code": "GR",
        "dial": "30",
        "flag": "🇬🇷",
        "flag_icon": "https://flagcdn.com/w20/gr.png"
    },
    {
        "name": "Greenland",
        "code": "GL",
        "dial": "299",
        "flag": "🇬🇱",
        "flag_icon": "https://flagcdn.com/w20/gl.png"
    },
    {
        "name": "Grenada",
        "code": "GD",
        "dial": "1473",
        "flag": "🇬🇩",
        "flag_icon": "https://flagcdn.com/w20/gd.png"
    },
    {
        "name": "Guadeloupe",
        "code": "GP",
        "dial": "590",
        "flag": "🇬🇵",
        "flag_icon": "https://flagcdn.com/w20/gp.png"
    },
    {
        "name": "Guam",
        "code": "GU",
        "dial": "1671",
        "flag": "🇬🇺",
        "flag_icon": "https://flagcdn.com/w20/gu.png"
    },
    {
        "name": "Guatemala",
        "code": "GT",
        "dial": "502",
        "flag": "🇬🇹",
        "flag_icon": "https://flagcdn.com/w20/gt.png"
    },
    {
        "name": "Guernsey",
        "code": "GG",
        "dial": "44",
        "flag": "🇬🇬",
        "flag_icon": "https://flagcdn.com/w20/gg.png"
    },
    {
        "name": "Guinea",
        "code": "GN",
        "dial": "224",
        "flag": "🇬🇳",
        "flag_icon": "https://flagcdn.com/w20/gn.png"
    },
    {
        "name": "Guinea-Bissau",
        "code": "GW",
        "dial": "245",
        "flag": "🇬🇼",
        "flag_icon": "https://flagcdn.com/w20/gw.png"
    },
    {
        "name": "Guyana",
        "code": "GY",
        "dial": "595",
        "flag": "🇬🇾",
        "flag_icon": "https://flagcdn.com/w20/gy.png"
    },
    {
        "name": "Haiti",
        "code": "HT",
        "dial": "509",
        "flag": "🇭🇹",
        "flag_icon": "https://flagcdn.com/w20/ht.png"
    },
    {
        "name": "Holy See (Vatican City State)",
        "code": "VA",
        "dial": "379",
        "flag": "🇻🇦",
        "flag_icon": "https://flagcdn.com/w20/va.png"
    },
    {
        "name": "Honduras",
        "code": "HN",
        "dial": "504",
        "flag": "🇭🇳",
        "flag_icon": "https://flagcdn.com/w20/hn.png"
    },
    {
        "name": "Hong Kong",
        "code": "HK",
        "dial": "852",
        "flag": "🇭🇰",
        "flag_icon": "https://flagcdn.com/w20/hk.png"
    },
    {
        "name": "Hungary",
        "code": "HU",
        "dial": "36",
        "flag": "🇭🇺",
        "flag_icon": "https://flagcdn.com/w20/hu.png"
    },
    {
        "name": "Iceland",
        "code": "IS",
        "dial": "354",
        "flag": "🇮🇸",
        "flag_icon": "https://flagcdn.com/w20/is.png"
    },
    {
        "name": "India",
        "code": "IN",
        "dial": "91",
        "flag": "🇮🇳",
        "flag_icon": "https://flagcdn.com/w20/in.png"
    },
    {
        "name": "Indonesia",
        "code": "ID",
        "dial": "62",
        "flag": "🇮🇩",
        "flag_icon": "https://flagcdn.com/w20/id.png"
    },
    {
        "name": "Iran, Islamic Republic of Persian Gulf",
        "code": "IR",
        "dial": "98",
        "flag": "🇮🇷",
        "flag_icon": "https://flagcdn.com/w20/ir.png"
    },
    {
        "name": "Iraq",
        "code": "IQ",
        "dial": "964",
        "flag": "🇮🇶",
        "flag_icon": "https://flagcdn.com/w20/iq.png"
    },
    {
        "name": "Ireland",
        "code": "IE",
        "dial": "353",
        "flag": "🇮🇪",
        "flag_icon": "https://flagcdn.com/w20/ie.png"
    },
    {
        "name": "Isle of Man",
        "code": "IM",
        "dial": "44",
        "flag": "🇮🇲",
        "flag_icon": "https://flagcdn.com/w20/im.png"
    },
    {
        "name": "Israel",
        "code": "IL",
        "dial": "972",
        "flag": "🇮🇱",
        "flag_icon": "https://flagcdn.com/w20/il.png"
    },
    {
        "name": "Italy",
        "code": "IT",
        "dial": "39",
        "flag": "🇮🇹",
        "flag_icon": "https://flagcdn.com/w20/it.png"
    },
    {
        "name": "Jamaica",
        "code": "JM",
        "dial": "1876",
        "flag": "🇯🇲",
        "flag_icon": "https://flagcdn.com/w20/jm.png"
    },
    {
        "name": "Japan",
        "code": "JP",
        "dial": "81",
        "flag": "🇯🇵",
        "flag_icon": "https://flagcdn.com/w20/jp.png"
    },
    {
        "name": "Jersey",
        "code": "JE",
        "dial": "44",
        "flag": "🇯🇪",
        "flag_icon": "https://flagcdn.com/w20/je.png"
    },
    {
        "name": "Jordan",
        "code": "JO",
        "dial": "962",
        "flag": "🇯🇴",
        "flag_icon": "https://flagcdn.com/w20/jo.png"
    },
    {
        "name": "Kazakhstan",
        "code": "KZ",
        "dial": "77",
        "flag": "🇰🇿",
        "flag_icon": "https://flagcdn.com/w20/kz.png"
    },
    {
        "name": "Kenya",
        "code": "KE",
        "dial": "254",
        "flag": "🇰🇪",
        "flag_icon": "https://flagcdn.com/w20/ke.png"
    },
    {
        "name": "Kiribati",
        "code": "KI",
        "dial": "686",
        "flag": "🇰🇮",
        "flag_icon": "https://flagcdn.com/w20/ki.png"
    },
    {
        "name": "Korea, Democratic People's Republic of Korea",
        "code": "KP",
        "dial": "850",
        "flag": "🇰🇵",
        "flag_icon": "https://flagcdn.com/w20/kp.png"
    },
    {
        "name": "Korea, Republic of South Korea",
        "code": "KR",
        "dial": "82",
        "flag": "🇰🇷",
        "flag_icon": "https://flagcdn.com/w20/kr.png"
    },
    {
        "name": "Kuwait",
        "code": "KW",
        "dial": "965",
        "flag": "🇰🇼",
        "flag_icon": "https://flagcdn.com/w20/kw.png"
    },
    {
        "name": "Kyrgyzstan",
        "code": "KG",
        "dial": "996",
        "flag": "🇰🇬",
        "flag_icon": "https://flagcdn.com/w20/kg.png"
    },
    {
        "name": "Laos",
        "code": "LA",
        "dial": "856",
        "flag": "🇱🇦",
        "flag_icon": "https://flagcdn.com/w20/la.png"
    },
    {
        "name": "Latvia",
        "code": "LV",
        "dial": "371",
        "flag": "🇱🇻",
        "flag_icon": "https://flagcdn.com/w20/lv.png"
    },
    {
        "name": "Lebanon",
        "code": "LB",
        "dial": "961",
        "flag": "🇱🇧",
        "flag_icon": "https://flagcdn.com/w20/lb.png"
    },
    {
        "name": "Lesotho",
        "code": "LS",
        "dial": "266",
        "flag": "🇱🇸",
        "flag_icon": "https://flagcdn.com/w20/ls.png"
    },
    {
        "name": "Liberia",
        "code": "LR",
        "dial": "231",
        "flag": "🇱🇷",
        "flag_icon": "https://flagcdn.com/w20/lr.png"
    },
    {
        "name": "Libyan Arab Jamahiriya",
        "code": "LY",
        "dial": "218",
        "flag": "🇱🇾",
        "flag_icon": "https://flagcdn.com/w20/ly.png"
    },
    {
        "name": "Liechtenstein",
        "code": "LI",
        "dial": "423",
        "flag": "🇱🇮",
        "flag_icon": "https://flagcdn.com/w20/li.png"
    },
    {
        "name": "Lithuania",
        "code": "LT",
        "dial": "370",
        "flag": "🇱🇹",
        "flag_icon": "https://flagcdn.com/w20/lt.png"
    },
    {
        "name": "Luxembourg",
        "code": "LU",
        "dial": "352",
        "flag": "🇱🇺",
        "flag_icon": "https://flagcdn.com/w20/lu.png"
    },
    {
        "name": "Macao",
        "code": "MO",
        "dial": "853",
        "flag": "🇲🇴",
        "flag_icon": "https://flagcdn.com/w20/mo.png"
    },
    {
        "name": "Macedonia",
        "code": "MK",
        "dial": "389",
        "flag": "🇲🇰",
        "flag_icon": "https://flagcdn.com/w20/mk.png"
    },
    {
        "name": "Madagascar",
        "code": "MG",
        "dial": "261",
        "flag": "🇲🇬",
        "flag_icon": "https://flagcdn.com/w20/mg.png"
    },
    {
        "name": "Malawi",
        "code": "MW",
        "dial": "265",
        "flag": "🇲🇼",
        "flag_icon": "https://flagcdn.com/w20/mw.png"
    },
    {
        "name": "Malaysia",
        "code": "MY",
        "dial": "60",
        "flag": "🇲🇾",
        "flag_icon": "https://flagcdn.com/w20/my.png"
    },
    {
        "name": "Maldives",
        "code": "MV",
        "dial": "960",
        "flag": "🇲🇻",
        "flag_icon": "https://flagcdn.com/w20/mv.png"
    },
    {
        "name": "Mali",
        "code": "ML",
        "dial": "223",
        "flag": "🇲🇱",
        "flag_icon": "https://flagcdn.com/w20/ml.png"
    },
    {
        "name": "Malta",
        "code": "MT",
        "dial": "356",
        "flag": "🇲🇹",
        "flag_icon": "https://flagcdn.com/w20/mt.png"
    },
    {
        "name": "Marshall Islands",
        "code": "MH",
        "dial": "692",
        "flag": "🇲🇭",
        "flag_icon": "https://flagcdn.com/w20/mh.png"
    },
    {
        "name": "Martinique",
        "code": "MQ",
        "dial": "596",
        "flag": "🇲🇶",
        "flag_icon": "https://flagcdn.com/w20/mq.png"
    },
    {
        "name": "Mauritania",
        "code": "MR",
        "dial": "222",
        "flag": "🇲🇷",
        "flag_icon": "https://flagcdn.com/w20/mr.png"
    },
    {
        "name": "Mauritius",
        "code": "MU",
        "dial": "230",
        "flag": "🇲🇺",
        "flag_icon": "https://flagcdn.com/w20/mu.png"
    },
    {
        "name": "Mayotte",
        "code": "YT",
        "dial": "262",
        "flag": "🇾🇹",
        "flag_icon": "https://flagcdn.com/w20/yt.png"
    },
    {
        "name": "Mexico",
        "code": "MX",
        "dial": "52",
        "flag": "🇲🇽",
        "flag_icon": "https://flagcdn.com/w20/mx.png"
    },
    {
        "name": "Micronesia, Federated States of Micronesia",
        "code": "FM",
        "dial": "691",
        "flag": "🇫🇲",
        "flag_icon": "https://flagcdn.com/w20/fm.png"
    },
    {
        "name": "Moldova",
        "code": "MD",
        "dial": "373",
        "flag": "🇲🇩",
        "flag_icon": "https://flagcdn.com/w20/md.png"
    },
    {
        "name": "Monaco",
        "code": "MC",
        "dial": "377",
        "flag": "🇲🇨",
        "flag_icon": "https://flagcdn.com/w20/mc.png"
    },
    {
        "name": "Mongolia",
        "code": "MN",
        "dial": "976",
        "flag": "🇲🇳",
        "flag_icon": "https://flagcdn.com/w20/mn.png"
    },
    {
        "name": "Montenegro",
        "code": "ME",
        "dial": "382",
        "flag": "🇲🇪",
        "flag_icon": "https://flagcdn.com/w20/me.png"
    },
    {
        "name": "Montserrat",
        "code": "MS",
        "dial": "1664",
        "flag": "🇲🇸",
        "flag_icon": "https://flagcdn.com/w20/ms.png"
    },
    {
        "name": "Morocco",
        "code": "MA",
        "dial": "212",
        "flag": "🇲🇦",
        "flag_icon": "https://flagcdn.com/w20/ma.png"
    },
    {
        "name": "Mozambique",
        "code": "MZ",
        "dial": "258",
        "flag": "🇲🇿",
        "flag_icon": "https://flagcdn.com/w20/mz.png"
    },
    {
        "name": "Myanmar",
        "code": "MM",
        "dial": "95",
        "flag": "🇲🇲",
        "flag_icon": "https://flagcdn.com/w20/mm.png"
    },
    {
        "name": "Namibia",
        "code": "NA",
        "dial": "264",
        "flag": "🇳🇦",
        "flag_icon": "https://flagcdn.com/w20/na.png"
    },
    {
        "name": "Nauru",
        "code": "NR",
        "dial": "674",
        "flag": "🇳🇷",
        "flag_icon": "https://flagcdn.com/w20/nr.png"
    },
    {
        "name": "Nepal",
        "code": "NP",
        "dial": "977",
        "flag": "🇳🇵",
        "flag_icon": "https://flagcdn.com/w20/np.png"
    },
    {
        "name": "Netherlands",
        "code": "NL",
        "dial": "31",
        "flag": "🇳🇱",
        "flag_icon": "https://flagcdn.com/w20/nl.png"
    },
    {
        "name": "Netherlands Antilles",
        "code": "AN",
        "dial": "599",
        "flag": "🇦🇳",
        "flag_icon": "https://flagcdn.com/w20/an.png"
    },
    {
        "name": "New Caledonia",
        "code": "NC",
        "dial": "687",
        "flag": "🇳🇨",
        "flag_icon": "https://flagcdn.com/w20/nc.png"
    },
    {
        "name": "New Zealand",
        "code": "NZ",
        "dial": "64",
        "flag": "🇳🇿",
        "flag_icon": "https://flagcdn.com/w20/nz.png"
    },
    {
        "name": "Nicaragua",
        "code": "NI",
        "dial": "505",
        "flag": "🇳🇮",
        "flag_icon": "https://flagcdn.com/w20/ni.png"
    },
    {
        "name": "Niger",
        "code": "NE",
        "dial": "227",
        "flag": "🇳🇪",
        "flag_icon": "https://flagcdn.com/w20/ne.png"
    },
    {
        "name": "Nigeria",
        "code": "NG",
        "dial": "234",
        "flag": "🇳🇬",
        "flag_icon": "https://flagcdn.com/w20/ng.png"
    },
    {
        "name": "Niue",
        "code": "NU",
        "dial": "683",
        "flag": "🇳🇺",
        "flag_icon": "https://flagcdn.com/w20/nu.png"
    },
    {
        "name": "Norfolk Island",
        "code": "NF",
        "dial": "672",
        "flag": "🇳🇫",
        "flag_icon": "https://flagcdn.com/w20/nf.png"
    },
    {
        "name": "Northern Mariana Islands",
        "code": "MP",
        "dial": "1670",
        "flag": "🇲🇵",
        "flag_icon": "https://flagcdn.com/w20/mp.png"
    },
    {
        "name": "Norway",
        "code": "NO",
        "dial": "47",
        "flag": "🇳🇴",
        "flag_icon": "https://flagcdn.com/w20/no.png"
    },
    {
        "name": "Oman",
        "code": "OM",
        "dial": "968",
        "flag": "🇴🇲",
        "flag_icon": "https://flagcdn.com/w20/om.png"
    },
    {
        "name": "Pakistan",
        "code": "PK",
        "dial": "92",
        "flag": "🇵🇰",
        "flag_icon": "https://flagcdn.com/w20/pk.png"
    },
    {
        "name": "Palau",
        "code": "PW",
        "dial": "680",
        "flag": "🇵🇼",
        "flag_icon": "https://flagcdn.com/w20/pw.png"
    },
    {
        "name": "Palestinian Territory, Occupied",
        "code": "PS",
        "dial": "970",
        "flag": "🇵🇸",
        "flag_icon": "https://flagcdn.com/w20/ps.png"
    },
    {
        "name": "Panama",
        "code": "PA",
        "dial": "507",
        "flag": "🇵🇦",
        "flag_icon": "https://flagcdn.com/w20/pa.png"
    },
    {
        "name": "Papua New Guinea",
        "code": "PG",
        "dial": "675",
        "flag": "🇵🇬",
        "flag_icon": "https://flagcdn.com/w20/pg.png"
    },
    {
        "name": "Paraguay",
        "code": "PY",
        "dial": "595",
        "flag": "🇵🇾",
        "flag_icon": "https://flagcdn.com/w20/py.png"
    },
    {
        "name": "Peru",
        "code": "PE",
        "dial": "51",
        "flag": "🇵🇪",
        "flag_icon": "https://flagcdn.com/w20/pe.png"
    },
    {
        "name": "Philippines",
        "code": "PH",
        "dial": "63",
        "flag": "🇵🇭",
        "flag_icon": "https://flagcdn.com/w20/ph.png"
    },
    {
        "name": "Pitcairn",
        "code": "PN",
        "dial": "872",
        "flag": "🇵🇳",
        "flag_icon": "https://flagcdn.com/w20/pn.png"
    },
    {
        "name": "Poland",
        "code": "PL",
        "dial": "48",
        "flag": "🇵🇱",
        "flag_icon": "https://flagcdn.com/w20/pl.png"
    },
    {
        "name": "Portugal",
        "code": "PT",
        "dial": "351",
        "flag": "🇵🇹",
        "flag_icon": "https://flagcdn.com/w20/pt.png"
    },
    {
        "name": "Puerto Rico",
        "code": "PR",
        "dial": "1939",
        "flag": "🇵🇷",
        "flag_icon": "https://flagcdn.com/w20/pr.png"
    },
    {
        "name": "Qatar",
        "code": "QA",
        "dial": "974",
        "flag": "🇶🇦",
        "flag_icon": "https://flagcdn.com/w20/qa.png"
    },
    {
        "name": "Romania",
        "code": "RO",
        "dial": "40",
        "flag": "🇷🇴",
        "flag_icon": "https://flagcdn.com/w20/ro.png"
    },
    {
        "name": "Russia",
        "code": "RU",
        "dial": "7",
        "flag": "🇷🇺",
        "flag_icon": "https://flagcdn.com/w20/ru.png"
    },
    {
        "name": "Rwanda",
        "code": "RW",
        "dial": "250",
        "flag": "🇷🇼",
        "flag_icon": "https://flagcdn.com/w20/rw.png"
    },
    {
        "name": "Reunion",
        "code": "RE",
        "dial": "262",
        "flag": "🇷🇪",
        "flag_icon": "https://flagcdn.com/w20/re.png"
    },
    {
        "name": "Saint Barthelemy",
        "code": "BL",
        "dial": "590",
        "flag": "🇧🇱",
        "flag_icon": "https://flagcdn.com/w20/bl.png"
    },
    {
        "name": "Saint Helena, Ascension and Tristan Da Cunha",
        "code": "SH",
        "dial": "290",
        "flag": "🇸🇭",
        "flag_icon": "https://flagcdn.com/w20/sh.png"
    },
    {
        "name": "Saint Kitts and Nevis",
        "code": "KN",
        "dial": "1869",
        "flag": "🇰🇳",
        "flag_icon": "https://flagcdn.com/w20/kn.png"
    },
    {
        "name": "Saint Lucia",
        "code": "LC",
        "dial": "1758",
        "flag": "🇱🇨",
        "flag_icon": "https://flagcdn.com/w20/lc.png"
    },
    {
        "name": "Saint Martin",
        "code": "MF",
        "dial": "590",
        "flag": "🇲🇫",
        "flag_icon": "https://flagcdn.com/w20/mf.png"
    },
    {
        "name": "Saint Pierre and Miquelon",
        "code": "PM",
        "dial": "508",
        "flag": "🇵🇲",
        "flag_icon": "https://flagcdn.com/w20/pm.png"
    },
    {
        "name": "Saint Vincent and the Grenadines",
        "code": "VC",
        "dial": "1784",
        "flag": "🇻🇨",
        "flag_icon": "https://flagcdn.com/w20/vc.png"
    },
    {
        "name": "Samoa",
        "code": "WS",
        "dial": "685",
        "flag": "🇼🇸",
        "flag_icon": "https://flagcdn.com/w20/ws.png"
    },
    {
        "name": "San Marino",
        "code": "SM",
        "dial": "378",
        "flag": "🇸🇲",
        "flag_icon": "https://flagcdn.com/w20/sm.png"
    },
    {
        "name": "Sao Tome and Principe",
        "code": "ST",
        "dial": "239",
        "flag": "🇸🇹",
        "flag_icon": "https://flagcdn.com/w20/st.png"
    },
    {
        "name": "Saudi Arabia",
        "code": "SA",
        "dial": "966",
        "flag": "🇸🇦",
        "flag_icon": "https://flagcdn.com/w20/sa.png"
    },
    {
        "name": "Senegal",
        "code": "SN",
        "dial": "221",
        "flag": "🇸🇳",
        "flag_icon": "https://flagcdn.com/w20/sn.png"
    },
    {
        "name": "Serbia",
        "code": "RS",
        "dial": "381",
        "flag": "🇷🇸",
        "flag_icon": "https://flagcdn.com/w20/rs.png"
    },
    {
        "name": "Seychelles",
        "code": "SC",
        "dial": "248",
        "flag": "🇸🇨",
        "flag_icon": "https://flagcdn.com/w20/sc.png"
    },
    {
        "name": "Sierra Leone",
        "code": "SL",
        "dial": "232",
        "flag": "🇸🇱",
        "flag_icon": "https://flagcdn.com/w20/sl.png"
    },
    {
        "name": "Singapore",
        "code": "SG",
        "dial": "65",
        "flag": "🇸🇬",
        "flag_icon": "https://flagcdn.com/w20/sg.png"
    },
    {
        "name": "Slovakia",
        "code": "SK",
        "dial": "421",
        "flag": "🇸🇰",
        "flag_icon": "https://flagcdn.com/w20/sk.png"
    },
    {
        "name": "Slovenia",
        "code": "SI",
        "dial": "386",
        "flag": "🇸🇮",
        "flag_icon": "https://flagcdn.com/w20/si.png"
    },
    {
        "name": "Solomon Islands",
        "code": "SB",
        "dial": "677",
        "flag": "🇸🇧",
        "flag_icon": "https://flagcdn.com/w20/sb.png"
    },
    {
        "name": "Somalia",
        "code": "SO",
        "dial": "252",
        "flag": "🇸🇴",
        "flag_icon": "https://flagcdn.com/w20/so.png"
    },
    {
        "name": "South Africa",
        "code": "ZA",
        "dial": "27",
        "flag": "🇿🇦",
        "flag_icon": "https://flagcdn.com/w20/za.png"
    },
    {
        "name": "South Sudan",
        "code": "SS",
        "dial": "211",
        "flag": "🇸🇸",
        "flag_icon": "https://flagcdn.com/w20/ss.png"
    },
    {
        "name": "South Georgia and the South Sandwich Islands",
        "code": "GS",
        "dial": "500",
        "flag": "🇬🇸",
        "flag_icon": "https://flagcdn.com/w20/gs.png"
    },
    {
        "name": "Spain",
        "code": "ES",
        "dial": "34",
        "flag": "🇪🇸",
        "flag_icon": "https://flagcdn.com/w20/es.png"
    },
    {
        "name": "Sri Lanka",
        "code": "LK",
        "dial": "94",
        "flag": "🇱🇰",
        "flag_icon": "https://flagcdn.com/w20/lk.png"
    },
    {
        "name": "Sudan",
        "code": "SD",
        "dial": "249",
        "flag": "🇸🇩",
        "flag_icon": "https://flagcdn.com/w20/sd.png"
    },
    {
        "name": "Suriname",
        "code": "SR",
        "dial": "597",
        "flag": "🇸🇷",
        "flag_icon": "https://flagcdn.com/w20/sr.png"
    },
    {
        "name": "Svalbard and Jan Mayen",
        "code": "SJ",
        "dial": "47",
        "flag": "🇸🇯",
        "flag_icon": "https://flagcdn.com/w20/sj.png"
    },
    {
        "name": "Swaziland",
        "code": "SZ",
        "dial": "268",
        "flag": "🇸🇿",
        "flag_icon": "https://flagcdn.com/w20/sz.png"
    },
    {
        "name": "Sweden",
        "code": "SE",
        "dial": "46",
        "flag": "🇸🇪",
        "flag_icon": "https://flagcdn.com/w20/se.png"
    },
    {
        "name": "Switzerland",
        "code": "CH",
        "dial": "41",
        "flag": "🇨🇭",
        "flag_icon": "https://flagcdn.com/w20/ch.png"
    },
    {
        "name": "Syrian Arab Republic",
        "code": "SY",
        "dial": "963",
        "flag": "🇸🇾",
        "flag_icon": "https://flagcdn.com/w20/sy.png"
    },
    {
        "name": "Taiwan",
        "code": "TW",
        "dial": "886",
        "flag": "🇹🇼",
        "flag_icon": "https://flagcdn.com/w20/tw.png"
    },
    {
        "name": "Tajikistan",
        "code": "TJ",
        "dial": "992",
        "flag": "🇹🇯",
        "flag_icon": "https://flagcdn.com/w20/tj.png"
    },
    {
        "name": "Tanzania, United Republic of Tanzania",
        "code": "TZ",
        "dial": "255",
        "flag": "🇹🇿",
        "flag_icon": "https://flagcdn.com/w20/tz.png"
    },
    {
        "name": "Thailand",
        "code": "TH",
        "dial": "66",
        "flag": "🇹🇭",
        "flag_icon": "https://flagcdn.com/w20/th.png"
    },
    {
        "name": "Timor-Leste",
        "code": "TL",
        "dial": "670",
        "flag": "🇹🇱",
        "flag_icon": "https://flagcdn.com/w20/tl.png"
    },
    {
        "name": "Togo",
        "code": "TG",
        "dial": "228",
        "flag": "🇹🇬",
        "flag_icon": "https://flagcdn.com/w20/tg.png"
    },
    {
        "name": "Tokelau",
        "code": "TK",
        "dial": "690",
        "flag": "🇹🇰",
        "flag_icon": "https://flagcdn.com/w20/tk.png"
    },
    {
        "name": "Tonga",
        "code": "TO",
        "dial": "676",
        "flag": "🇹🇴",
        "flag_icon": "https://flagcdn.com/w20/to.png"
    },
    {
        "name": "Trinidad and Tobago",
        "code": "TT",
        "dial": "1868",
        "flag": "🇹🇹",
        "flag_icon": "https://flagcdn.com/w20/tt.png"
    },
    {
        "name": "Tunisia",
        "code": "TN",
        "dial": "216",
        "flag": "🇹🇳",
        "flag_icon": "https://flagcdn.com/w20/tn.png"
    },
    {
        "name": "Turkey",
        "code": "TR",
        "dial": "90",
        "flag": "🇹🇷",
        "flag_icon": "https://flagcdn.com/w20/tr.png"
    },
    {
        "name": "Turkmenistan",
        "code": "TM",
        "dial": "993",
        "flag": "🇹🇲",
        "flag_icon": "https://flagcdn.com/w20/tm.png"
    },
    {
        "name": "Turks and Caicos Islands",
        "code": "TC",
        "dial": "1649",
        "flag": "🇹🇨",
        "flag_icon": "https://flagcdn.com/w20/tc.png"
    },
    {
        "name": "Tuvalu",
        "code": "TV",
        "dial": "688",
        "flag": "🇹🇻",
        "flag_icon": "https://flagcdn.com/w20/tv.png"
    },
    {
        "name": "Uganda",
        "code": "UG",
        "dial": "256",
        "flag": "🇺🇬",
        "flag_icon": "https://flagcdn.com/w20/ug.png"
    },
    {
        "name": "Ukraine",
        "code": "UA",
        "dial": "380",
        "flag": "🇺🇦",
        "flag_icon": "https://flagcdn.com/w20/ua.png"
    },
    {
        "name": "United Arab Emirates",
        "code": "AE",
        "dial": "971",
        "flag": "🇦🇪",
        "flag_icon": "https://flagcdn.com/w20/ae.png"
    },
    {
        "name": "United Kingdom",
        "code": "GB",
        "dial": "44",
        "flag": "🇬🇧",
        "flag_icon": "https://flagcdn.com/w20/gb.png"
    },
    {
        "name": "United States",
        "code": "US",
        "dial": "1",
        "flag": "🇺🇸",
        "flag_icon": "https://flagcdn.com/w20/us.png"
    },
    {
        "name": "Uruguay",
        "code": "UY",
        "dial": "598",
        "flag": "🇺🇾",
        "flag_icon": "https://flagcdn.com/w20/uy.png"
    },
    {
        "name": "Uzbekistan",
        "code": "UZ",
        "dial": "998",
        "flag": "🇺🇿",
        "flag_icon": "https://flagcdn.com/w20/uz.png"
    },
    {
        "name": "Vanuatu",
        "code": "VU",
        "dial": "678",
        "flag": "🇻🇺",
        "flag_icon": "https://flagcdn.com/w20/vu.png"
    },
    {
        "name": "Venezuela, Bolivarian Republic of Venezuela",
        "code": "VE",
        "dial": "58",
        "flag": "🇻🇪",
        "flag_icon": "https://flagcdn.com/w20/ve.png"
    },
    {
        "name": "Vietnam",
        "code": "VN",
        "dial": "84",
        "flag": "🇻🇳",
        "flag_icon": "https://flagcdn.com/w20/vn.png"
    },
    {
        "name": "Virgin Islands, British",
        "code": "VG",
        "dial": "1284",
        "flag": "🇻🇬",
        "flag_icon": "https://flagcdn.com/w20/vg.png"
    },
    {
        "name": "Virgin Islands, U.S.",
        "code": "VI",
        "dial": "1340",
        "flag": "🇻🇮",
        "flag_icon": "https://flagcdn.com/w20/vi.png"
    },
    {
        "name": "Wallis and Futuna",
        "code": "WF",
        "dial": "681",
        "flag": "🇼🇫",
        "flag_icon": "https://flagcdn.com/w20/wf.png"
    },
    {
        "name": "Yemen",
        "code": "YE",
        "dial": "967",
        "flag": "🇾🇪",
        "flag_icon": "https://flagcdn.com/w20/ye.png"
    },
    {
        "name": "Zambia",
        "code": "ZM",
        "dial": "260",
        "flag": "🇿🇲",
        "flag_icon": "https://flagcdn.com/w20/zm.png"
    },
    {
        "name": "Zimbabwe",
        "code": "ZW",
        "dial": "263",
        "flag": "🇿🇼",
        "flag_icon": "https://flagcdn.com/w20/zw.png"
    }
]



export function getCountry(value:string ) {
    const country = COUNTRIES.find((c) => c.code === value) || COUNTRIES.find((c) => c.dial === value) || COUNTRIES.find((c) => c.dial === "91") ||COUNTRIES[0]
    return country
}