export const VALIDATION_PATTERNS = {
  // 6 Digit OTP (Numbers only)
  otp: /^\d{6}$/,

  // Names: Allows letters, spaces, hyphens (2-50 chars)
  name: /^[a-zA-Z\s-]{2,50}$/,

  // Email: Standard RFC 5322 format
  email: /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/,

  // Phone: International format (e.g., +1234567890) or local (10+ digits)
  phone: /^\+?[1-9]\d{1,14}$/,

  // DOB: YYYY-MM-DD format
  dob: /^\d{4}-(0[1-9]|1[0-2])-(0[1-9]|[12]\d|3[01])$/,

  // Gender: Specific options
  gender: /^(male|female|other|prefer_not_to_say)$/i,

  // UUID/ID: Standard alphanumeric + hyphens
  id: /^[a-f\d]{24}$|^[0-9a-fA-F]{8}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{12}$/
};



const validateField = (name: string, value: string): boolean => {
  switch (name) {
    case 'first_name':
    case 'last_name':
      return VALIDATION_PATTERNS.name.test(value);
    case 'email':
    case 'primary_email':
    case 'recovery_email':
      return VALIDATION_PATTERNS.email.test(value);
    case 'phone_number':
    case 'recovery_phone':
      return VALIDATION_PATTERNS.phone.test(value);
    case 'otp':
      return VALIDATION_PATTERNS.otp.test(value);
    case 'gender':
      return VALIDATION_PATTERNS.gender.test(value);
    case 'dob':
      return VALIDATION_PATTERNS.dob.test(value);
    default:
      return true; // Address and others are usually less strict
  }
};



