import mongoose, { Schema, models } from "mongoose";

const UserSchema = new Schema(
  {
    firstName: { type: String, required: true },
    lastName: { type: String },

    phoneNumber: { type: String, required: true, unique: true },
    primaryEmail: { type: String, required: true, unique: true },

    recoveryPhone: { type: String },
    recoveryEmail: { type: String },
    address: { type: String },

    password: { type: String, required: true },

    role: { type: String, default: "user" },
    isActive: { type: Boolean, default: true },
    isVerified: { type: Boolean, default: false },

    lastLoginAt: { type: Date },
  },
  { timestamps: true }
);

export default models.User || mongoose.model("User", UserSchema);
