import axios from 'axios';

const API_URL = process.env.NEXT_PUBLIC_API_URL || 'http://localhost:8000/api';

export const authService = {
  // Step 1: Check if email exists
  async checkIdentifier(identifier: string) {
    const response = await axios.post(`${API_URL}/auth/check-user/`, { identifier });
    return response.data; // Should return { exists: true, name: "Ananda..." }
  },

  // Step 2: Final Login
  async login(credentials: { identifier: string; password: any }) {
    const response = await axios.post(`${API_URL}/auth/login/`, credentials);
    return response.data; // JWT tokens
  },

  async register(data: any) {
    const response = await axios.post(`${API_URL}/auth/register/`, data);
    return response.data;
  }
};