if (editingField) {
    return (
      <div className="max-w-3xl mx-auto pt-8 pb-20 px-4 animate-in fade-in slide-in-from-bottom-4" ref={containerRef}>
        <button onClick={() => setEditingField(null)} className="flex items-center gap-2 text-muted-foreground mb-8">
          <ArrowLeft size={20} /> <span className="text-sm font-medium">Back</span>
        </button>

        <div className="space-y-6">
          <h1 className="text-3xl font-normal capitalize">
            {editingField === "primaryEmail" ? "Email address" : editingField.replace(/([A-Z])/g, ' $1')}
          </h1>

          <div className="bg-card border border-border rounded-2xl p-6 space-y-6 shadow-sm">

            {/* BIRTHDAY (CALENDAR VIEW) */}
            {editingField === "birthday" && (
              <div className="relative"
                onClick={() => setIsOpen(!isOpen)}
              >

                <input
                  type="text"
                  className="w-full bg-transparent border-2 border-muted focus:border-sidebar-primary rounded-xl px-4 py-4 outline-none appearance-none"
                  value={editBuffer.birthday}
                  onChange={(e) => setEditBuffer({ ...editBuffer, birthday: e.target.value })}
                />
                <Calendar className="absolute right-4 top-4 text-muted-foreground pointer-events-none" size={20} />

                <label className="absolute left-3 -top-2.5 px-2 bg-card text-xs text-sidebar-primary">Select Birthday</label>
              </div>
            )}

            {isOpen && (
              <div className="fixed w-full h-full top-0 left-0 z-50 flex justify-center align-middle animate-in fade-in zoom-in-95 duration-500" style={{
                alignItems: 'center',
                backdropFilter: 'blur(10px)'
              }}
              // onClick={() => setIsOpen(false)}
              >
                <CustomCalendar
                  selectedDate={editBuffer.birthday} // "2002-08-10"
                  onSelect={(newDate) => { setEditBuffer({ ...editBuffer, birthday: newDate }); setIsOpen(false) }}

                />
              </div>
            )}

            {/* EMAIL / RECOVERY / PHONE EDIT + VERIFY */}
            {(editingField === "primaryEmail" || editingField === "recoveryEmail" || editingField === "recoveryPhone") && (
              <div className="space-y-4">
                {/* Step 1: Input Field */}

                <div className="relative">
                  <input
                    type={editingField.includes("Email") ? "email" : "tel"}
                    disabled={isVerifying &&  sendOTPFor == editingField}
                    className={cn(
                      "w-full bg-transparent border-2 border-muted focus:border-sidebar-primary rounded-xl px-4 py-4 outline-none transition-all",
                      isVerifying && sendOTPFor == editingField && "opacity-50 cursor-not-allowed bg-muted/10",
                      // Optional: Add a green border if verified and not currently being edited/dirty
                      user[`${editingField.replace(/([A-Z])/g, '_$1').toLowerCase()}_verified`] && !isDirty && ""
                    )}
                    value={editBuffer[editingField]}
                    onChange={(e) => {
                      setEditBuffer({ ...editBuffer, [editingField]: e.target.value });
                      setIsDirty(true);
                      if (isVerifying) setIsVerifying(false);
                    }}
                  />
                  <label className="absolute left-3 -top-2.5 px-2 bg-card text-xs text-sidebar-primary uppercase flex items-center gap-1">
                    {editingField.replace(/([A-Z])/g, ' $1')}

                    {/* VERIFIED BADGE */}
                    {user[`${editingField.replace(/([A-Z])/g, '_$1').toLowerCase()}_verified`] && !isDirty && (
                      <span className="flex items-center text-[10px] text-green-600 dark:text-green-400 font-bold ml-1">
                        <CheckCircle2 size={10} className="mr-0.5" /> VERIFIED
                      </span>
                    )}
                  </label>
                </div>

                {editBuffer[editingField]?.length > 0 &&
                  !isVerifying &&
                  (!user[`${editingField.replace(/([A-Z])/g, '_$1').toLowerCase()}_verified`] || isDirty) && (
                    <div className="p-4 bg-amber-500/5 rounded-xl border border-dashed border-amber-500/30 flex items-center justify-between animate-in fade-in zoom-in-95">
                      <div className="flex items-center gap-3 text-sm text-amber-700 dark:text-amber-400 font-medium">
                        <AlertCircle size={18} />
                        <span>{isDirty ? "Verify your new details" : `Verify your ${editingField.includes("Email") ? "email" : "phone"}`}</span>
                      </div>
                      <button
                        type="button"
                        onClick={() => handleVerify()}
                        className="text-xs font-bold bg-sidebar-primary text-white px-4 py-2 rounded-lg hover:opacity-90 transition-all"
                      >
                        Authenticate and Save
        </button>
                    </div>
                  )}


                {/* Step 3: OTP Input Section (Only after clicking Verify) */}
                {isVerifying && sendOTPFor == editingField && (
                  <div className="p-6 bg-sidebar-primary/5 rounded-2xl border border-sidebar-primary/20 space-y-4 animate-in slide-in-from-top-4">
                    <div className="text-center space-y-1">
                      <p className="text-sm font-semibold text-foreground">Enter verification code</p>
                      <p className="text-xs text-muted-foreground">
                        {/* A 6-digit code was sent to {editBuffer[editingField]} */}
                         A 6-digit code was sent to {user?.phone_number}
                      </p>
                    </div>

                    <div className="flex justify-center">
                      <input
                        type="text"
                        maxLength={6}
                        placeholder="000000"
                        className="w-40 text-center bg-transparent border-b-2 border-sidebar-primary py-2 text-2xl tracking-[0.5em] font-bold outline-none"
                        value={otp}
                        onChange={(e) => setOtp(e.target.value.replace(/\D/g, ""))}
                      />
                    </div>

                    <div className="flex justify-center gap-4 pt-2">
                      <button
                        type="button"
                        onClick={() => handleChange()}
                        className="text-xs font-medium text-muted-foreground hover:text-foreground"
                      >
                        Change {editingField.includes("Email") ? "Email" : "Phone"}
                      </button>


                      <button
                        type="button"
                        onClick={handleResendClick}
                        disabled={resendCooldown > 0 || isResending}
                        className={`text-xs font-bold transition-all flex items-center gap-2
        ${resendCooldown > 0 || isResending
                            ? "text-muted-foreground cursor-not-allowed"
                            : "text-sidebar-primary hover:underline"
                          }`}
                      >
                        {isResending ? (
                          <>
                            <Loader2 className="animate-spin" size={12} />
                            <span>Sending code...</span>
                          </>
                        ) : resendCooldown > 0 ? (
                          <span>Try again in {resendCooldown}s</span>
                        ) : (
                              "Resend Code"
                            )}
                      </button>

                    </div>
                  </div>
                )}
              </div>
            )}


            {/* NAME EDIT */}
            {editingField === "name" && (
              <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div className="relative">
                  <input className="w-full bg-transparent border-2 border-muted focus:border-sidebar-primary rounded-xl px-4 py-3 outline-none"
                    value={editBuffer.firstName} onChange={(e) => setEditBuffer({ ...editBuffer, firstName: e.target.value })} />
                  <label className="absolute left-3 -top-2.5 px-2 bg-card text-xs text-sidebar-primary">First Name</label>
                </div>
                <div className="relative">
                  <input className="w-full bg-transparent border-2 border-muted focus:border-sidebar-primary rounded-xl px-4 py-3 outline-none"
                    value={editBuffer.lastName} onChange={(e) => setEditBuffer({ ...editBuffer, lastName: e.target.value })} />
                  <label className="absolute left-3 -top-2.5 px-2 bg-card text-xs text-sidebar-primary">Last Name</label>
                </div>
              </div>
            )}

            <div className="flex justify-end gap-3 pt-4 border-t border-border">
              <button disabled={isSaving} onClick={() => { setEditingField(null); closeEdit() }} className="px-5 py-2 text-sm font-semibold text-sidebar-primary">Cancel</button>
              <button
                onClick={handleSave}
                disabled={isSaving}
                className="bg-sidebar-primary text-white px-8 py-2 rounded-lg text-sm font-semibold flex items-center gap-2"
              >
                {isSaving ? <Loader2 size={16} className="animate-spin" /> : "Save"}
              </button>
            </div>
          </div>

          {(showToast) && (
            <div className="fixed z-[51] bottom-8 left-8 bg-[#323232] text-white px-6 py-3 rounded-lg shadow-2xl flex items-center gap-3 animate-in slide-in-from-left-10">
              <CheckCircle2 size={18} className="text-green-400" />
              <span className="text-sm">{toastMsg}</span>
            </div>
          )}
        </div>
      </div>
    );
  }


  if (loading) {
    return (
      <div className="h-screen w-full flex items-center justify-center bg-background">
        <div className="flex flex-col items-center gap-4">
          <Loader2 className="h-8 w-8 animate-spin text-sidebar-primary" />
          <p className="text-muted-foreground animate-pulse">Loading your account...</p>
        </div>
      </div>
    );
  }

  return (
    <div className="max-w-3xl mx-auto pt-8 pb-20 px-4 relative">
      <div className="mb-8">
        <h1 className="text-3xl font-normal mb-2">Personal info</h1>
        <p className="text-sm text-muted-foreground">Manage your identity and contact methods across Indzs.</p>
      </div>


      <div className="bg-background border border-border rounded-2xl overflow-hidden shadow-sm">

        <div className="flex items-center justify-between p-6 hover:bg-accent/30 cursor-pointer transition-colors border-b border-border group">
          <div className="flex items-center gap-6">
            <Camera size={20} className="text-muted-foreground" />
            <span className="text-base font-medium">Profile picture</span>
          </div>
          <div className="w-16 h-16 rounded-full bg-sidebar-primary/20 flex items-center justify-center text-2xl text-sidebar-primary relative overflow-hidden group">
            {profile.firstName.toUpperCase().charAt(0)}
            <div className="absolute inset-0 bg-black/40 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center">
              <Camera size={20} className="text-white" />
            </div>
          </div>
        </div>
        <InfoRow icon={User} label="Name" value={`${profile.firstName} ${profile.lastName}`} onClick={() => startEdit("name")} />

        
        <InfoRow
          icon={Mail}
          label="Primary Email"
          value={profile.primaryEmail}
          needsVerification={!profile.primaryEmailVerified}
          onClick={() => startEdit("primaryEmail")}
        />
        <InfoRow
          icon={Mail}
          label="Recovery Email"
          value={profile.recoveryEmail || "Not added"}
          needsVerification={profile.recoveryEmail && !profile.recoveryEmailVerified}
          onClick={() => startEdit("recoveryEmail")}
        />
        <InfoRow icon={Phone} label="Primary Phone" value={profile.primaryPhone} isLocked />
        <InfoRow
          icon={Phone}
          label="Recovery Phone"
          value={profile.recoveryPhone || "None added"}
          needsVerification={profile.recoveryPhone && !profile.recoveryPhoneVerified}
          onClick={() => startEdit("recoveryPhone")}
        />

       
        <InfoRow icon={Cake} label="Birthday" value={new Date(profile.birthday).toLocaleDateString('en-GB', { day: 'numeric', month: 'long', year: 'numeric' })} onClick={() => startEdit("birthday")} />
      </div>

      {(showToast) && (
        <div className="fixed z-[51] bottom-8 left-8 bg-[#323232] text-white px-6 py-3 rounded-lg shadow-2xl flex items-center gap-3 animate-in slide-in-from-left-10">
          <CheckCircle2 size={18} className="text-green-400" />
          <span className="text-sm">{toastMsg}</span>
        </div>
      )}
    </div>
  );