import { z } from "zod";

export const registerSchema = z.object({
  firstName: z.string().min(2),
  lastName: z.string().optional(),

  phoneNumber: z.string().regex(/^[6-9]\d{9}$/),
  primaryEmail: z.string().email(),

  recoveryPhone: z.string().optional(),
  recoveryEmail: z.string().email().optional(),
  address: z.string().optional(),

  password: z.string().min(8),
});
